! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> This module encapsulates the available isNaN implementation
!!
!! Here we use the vendor specific isNaN, as the IEEE version
!! is not supported by the compiler.
!!
module tem_isNaN_module

  ! include treelm modules
  use env_module, only: rk

  implicit none

  private

  public :: tem_isNaN

  contains

! ****************************************************************************** !
  elemental function tem_isNaN(num) result(noNumber)
    !---------------------------------------------------------------------------
    real(kind=rk), intent(in) :: num
    logical :: noNumber
    !---------------------------------------------------------------------------

    noNumber = isNaN(num)

  end function tem_isNaN
! ****************************************************************************** !


end module tem_isNaN_module
! ****************************************************************************** !
