!> This module provides some little functionality to easily write
!! data into files for debugging.
!!
!! It is related to [[tem_debug_module]], but intended for even smaller
!! tasks and specifically for tracking the evolution of values over the
!! runtime.
module tem_probing_module
  use env_module, only: newunit, rk

  implicit none


contains


  ! ------------------------------------------------------------------------ !
  !> Delete the file with the given name.
  !!
  !! Use this in the beginning of the application, to clear old logs.
  subroutine tem_probing_delete(filename)
    ! -------------------------------------------------------------------- !
    !> Name of the file to delete.
    character(len=*) :: filename
    ! -------------------------------------------------------------------- !
    logical :: is_oldfile
    integer :: probeunit
    ! -------------------------------------------------------------------- !

    inquire(file=trim(filename), exist = is_oldfile)
    probeunit = newunit()
    if (is_oldfile) then
      open( probeunit, file=filename, status='old', position='append', &
        &   action='write' )
    else
      open( probeunit, file=filename, status='new', action='write' )
    end if
    close(probeunit, status='delete')
  end subroutine tem_probing_delete
  ! ------------------------------------------------------------------------ !
  ! ------------------------------------------------------------------------ !


  ! ------------------------------------------------------------------------ !
  !> Write an array of reals into a file of the given name.
  subroutine tem_probing_write(filename, label, dat)
    ! -------------------------------------------------------------------- !
    !> Name of the file to write the data to.
    !! If the file already exists, the data will be appended.
    character(len=*), intent(in) :: filename

    !> Label to identify the point in the program execution, where the
    !! data was written.
    character(len=*), intent(in) :: label

    !> Data to write to the file
    real(kind=rk), intent(in) :: dat(:)
    ! -------------------------------------------------------------------- !
    logical :: is_oldfile
    integer :: probeunit
    ! -------------------------------------------------------------------- !

    inquire(file=trim(filename), exist = is_oldfile)
    probeunit = newunit()
    if (is_oldfile) then
      open( probeunit, file=filename, status='old', position='append', &
        &   action='write' )
    else
      open( probeunit, file=filename, status='new', action='write' )
    end if
    write(probeunit,*) dat, ' !', trim(label)

    close(probeunit)
  end subroutine tem_probing_write
  ! ------------------------------------------------------------------------ !
  ! ------------------------------------------------------------------------ !

end module tem_probing_module
