! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> Some auxilary routines, providing
!! frequently needed common tasks.
!!
module tem_solveHead_module

  ! include treelm modules
  use env_module,             only: LabelLen, PathLen
  ! This module has to be created on the fly by the waf environment
  use tem_revision_module,    only: tem_solver_revision

  ! include aotus module
  use aotus_module,    only: flu_State

  implicit none

  private

  public :: tem_solveHead_type
  public :: tem_solverTag
  public :: tem_init_solveHead

  !> Solver header information
  type tem_solveHead_type
    !> Name of current simulation
    character(len=PathLen) :: simName
    !> Mesh folder. set default to empty string
    character(len=PathLen)  :: meshFolder = ''
    !> main lua configfile full path.
    !! Default is set to empty string to do check on this
    !! before loading filename from command line
    character(len=PathLen)  :: configFile = ''
    character(len=LabelLen) :: solName    !< solver name
    character(len=LabelLen) :: version    !< version of the solver
    !> mercurial repository revision of the solver
    character(len=16) :: revision
    !> aotus lua conf state to load main configuration file
    !! and solver specific lua functions as chunk
    type(flu_state), allocatable :: conf(:)
    !> solver timer handle.
    !! use to lookup in timerData in timer_module to
    !! determine time taken for this solver
    integer :: timerHandle
    ! The filename to use for tracking the memory
    character(len=pathLen)       :: trackmem_file
  end type tem_solveHead_type

  contains

! ****************************************************************************** !
  !> Function to return a solver tag (combination of solver name and version)
  !!
  function tem_solverTag( solver ) result( tag )
    ! ---------------------------------------------------------------------------
    !> solver information
    type(tem_solveHead_type), intent(in) :: solver
    ! ---------------------------------------------------------------------------
    ! defining local variables
    character(len=LabelLen) :: tag  ! solver
    ! ---------------------------------------------------------------------------

    tag = trim(solver%solName)//'_'//trim(solver%version)
  end function tem_solverTag
! ****************************************************************************** !

! ****************************************************************************** !
  !> Routine to initialize solver head with name, version and revision number
  subroutine tem_init_solveHead( me, solName, version )
    !> solver info
    type( tem_solveHead_type), intent(out) :: me
    !> name of the solver
    character(len=*), intent(in) :: solName
    !> version of the solver
    character(len=*), intent(in) :: version
    ! ---------------------------------------------------------------------------

    me%solName  = trim(solName)
    me%version = trim(version)
    me%revision = tem_solver_revision

  end subroutine tem_init_solveHead
! ****************************************************************************** !

end module tem_solveHead_module
! ****************************************************************************** !
