! See copyright notice in the COPYRIGHT file.
?? include 'arrayMacros.inc'
module tem_stringKeyValuePair_module

  use env_module, only: labellen, minlength, zerolength

  implicit none

  private

  ! **************************************************************************** !
  !> Defines a key/value pair of strings that can be set or retrieved.
  type tem_stringKeyValuePair_type
    !> The key in the key/value pair. It's length is limited to /ref labellen.
    character(len=labellen) :: key
    !> The value in the key/value pair. It's length is limited to /ref labellen.
    character(len=labellen) :: value
  end type tem_stringKeyValuePair_type
  ! **************************************************************************** !

  interface operator (==)
    module procedure tem_stringKVP_equals
  end interface

  interface operator (/=)
    module procedure tem_stringKVP_notEquals
  end interface

  public :: tem_stringKeyValuePair_type
  public :: grw_stringKeyValuePairArray_type
  public :: append, truncate, init, destroy
  public :: operator(==)
  public :: operator(/=)

?? copy :: GA_decltxt(stringKeyValuePair, type(tem_stringKeyValuePair_type))


contains


  ! *****************************************************************************
  !> Indicates whether this instance and a specified object are equal.
  pure function tem_stringKVP_equals(me, other) result (res)
    ! ---------------------------------------------------------------------------
    !> THe current instance.
    type(tem_stringKeyValuePair_type), intent(in) :: me
    !> The instance to compare with the current instance.
    type(tem_stringKeyValuePair_type), intent(in) :: other
    !> .true. when both instances are equal, otherwise .false.
    logical :: res
    ! ---------------------------------------------------------------------------

    res = (me%key == other%key) .and. (me%value == other%value)

  end function tem_stringKVP_equals
  ! *****************************************************************************

  ! *****************************************************************************
  !> Indicates whether this instance and a specified object are equal.
  pure function tem_stringKVP_notEquals(me, other) result (res)
    ! ---------------------------------------------------------------------------
    !> THe current instance.
    type(tem_stringKeyValuePair_type), intent(in) :: me
    !> The instance to compare with the current instance.
    type(tem_stringKeyValuePair_type), intent(in) :: other
    !> .true. when both instances are equal, otherwise .false.
    logical :: res
    ! ---------------------------------------------------------------------------

    res = .not. tem_stringKVP_equals(me, other)

  end function tem_stringKVP_notEquals
  ! *****************************************************************************

?? copy :: GA_impltxt(stringKeyValuePair, type(tem_stringKeyValuePair_type))

end module tem_stringKeyValuePair_module
