! See copyright notice in the COPYRIGHT file.
! This program tries to evaluate the memory demand per element
!
program elem_memAlloc

  ! include treelm modules
  use env_module,         only: long_k
  use tem_debug_module,   only: tem_reportStatus, tem_debug_type
  use tem_stencil_module, only: tem_stencilElement_type
  use tem_element_module, only: tem_element_type, getSize, getReqSize,init,    &
    &                           append, eT_fluid, destroy
  use tem_logging_module, only: tem_logging_init

  implicit none
  ! ----------------------------------------------------------------------------
  type(tem_element_type) :: elem
  type(tem_stencilElement_type) :: tStencil
  type(tem_debug_type) :: debug
  integer :: QQ, elemPos, iQQN, addedPos, nElems, iElem, iSize, iStencilSize
  integer, allocatable :: elemSize(:), stencilSize(:)
  logical :: error, wasAdded
  character(len=64) :: buffer
  integer(kind=long_k) :: nBytes, nReqBytes
  integer :: nElems_fluid
  ! ----------------------------------------------------------------------------
  nElems_fluid = 0
  error = .false.
  ! initialize the debug type
  call tem_logging_init( me    = debug%logger,                                 &
    &                    level = 10,                                           &
    &                    rank  = 0,                                            &
    &                    filename = 'tem_elem_memTrace.res' )

  ! Get initial memory demand
  call tem_reportStatus( debug = debug, level = 1, &
                         text = 'starting overhead', string = 'VmRSS')
  allocate(elemSize(1))
  elemSize = [ 100 ] !, 1000000, 16777216 ]
  allocate(stencilSize(1))
  stencilSize = [ 0 ]

  do iStencilSize = 1, size( stencilSize )
    QQ = stencilSize( iStencilSize )
    write(*,*) 'Starting the memory analysis for QQ = ', QQ

    call init( me = tStencil, QQN = QQ-1, headerPos = 1 )
    do iSize = 1, size(elemSize)
      nElems = elemSize( iSize )
      write(*,*) 'analyzing with nElems ', nElems
      call init( me = elem )
      write(buffer,'(a,i10,a,i3)') 'starting to add nElems ', nElems, ' QQ', QQ
      call tem_reportStatus( debug = debug, level = 1, &
                             text = buffer, string = 'VmRSS')
      call getSize( me = elem, elemSize = nBytes )
      call getReqSize( me = elem, elemSize = nReqBytes )
      !write(*,*) 'elemSize at beginning', nBytes, elem%tID%containerSize, nReqBytes

      ! Create a list of dummy elements
      do iElem = 1, nElems
        !write(*,*) 'element number ', iElem
        ! Append a dummy element
        call append( me = elem, &
          &          tID = int( iElem, kind=long_k),  &
          &          pntTID = iElem,                  &
          &          eType = eT_fluid,                &
          &          nNeighIDs = QQ-1,                &
          &          sourceProc = 1,                  &
          &          property = 0_long_k,             &
          &          pos = elemPos, wasAdded = wasAdded )
        ! Append stencil neighbors to the neighbor array of the element
        do iQQN = 1, QQ-1
          call append( me  = elem%neighID%val( elemPos ),         &
            &          val = int( iQQN, kind=long_k),             &
            &          pos = addedPos, wasAdded = wasAdded )
          tStencil%tIDpos( iQQN ) = addedPos
        end do
        if ( QQ > 0 ) then
          ! Append the temporary stencil to the element
          call append( me = elem%stencil%val( elemPos ),            &
            &          val = tStencil )
        end if
      end do

      write(buffer,'(a,i10,a,i3)') 'finished adding nElems ', nElems, ' QQ', QQ
      call tem_reportStatus( debug = debug, level = 1, &
                             text = buffer, string = 'VmRSS')
      call getSize( me = elem, elemSize = nBytes )
      call getReqSize( me = elem, elemSize = nReqBytes )
      write(*,*) 'elemSize after adding all elems', nBytes/nElems,  &
      nReqBytes/nElems  

      call destroy( me = elem )
      write(buffer,'(a,i10,a,i3)') 'after destruction'
      call tem_reportStatus( debug = debug, level = 1, &
                             text = buffer, string = 'VmRSS')
    end do
    call destroy( me = tStencil )
  end do

  close( debug%logger%funit(0) )
  if( error ) then
    write(*,*) 'FAILED'
    stop -1
  else
    write(*,*) 'PASSED'
    stop 0 
  end if

end program elem_memAlloc
