require 'phi'

include Phi

module TreeDesc
  attr_accessor :desc
end

form = Form.new
panel = Panel.new form
panel.align = Phi::AL_TOP
btn_expand = Button.new panel, :expand
btn_expand.align = Phi::AL_LEFT
btn_collapse = Button.new panel, :collapse
btn_collapse.align = Phi::AL_LEFT

tree_view = TreeView.new form
tree_view.align = Phi::AL_CLIENT
tree_view.show_hint = true

#tree_view.on_expanding = proc {|i| p i; false}
tree_view.on_collapsing = proc {|i| p i; false}

expand_click = proc do
  tree_view.full_expand
end
btn_expand.on_click = expand_click

collapse_click = proc do
  tree_view.full_collapse
end
btn_collapse.on_click = collapse_click

mouse_move = proc do |sender, shift, x, y|
  tmp_node = tree_view.get_node_at(x, y)
  hittests = tree_view.get_hit_test_info_at(x, y)
  if tmp_node.instance_of?(Phi::TreeNode) and hittests.include?(Phi::HT_ON_ITEM)
    tree_view.hint = tmp_node.desc
    APPLICATION.activate_hint(sender.client_to_screen(Point.new(x, y)))
  else
    tree_view.hint = ''
  end
end
tree_view.on_mouse_move = mouse_move

image_list = ImageList.new
red = image_list.add_icon Icon.new.load 'aplo.ico'
green = image_list.add_icon Icon.new.load 'gaplo.ico'

tree_view.images = image_list
root_node = tree_view.items.add(nil, 'ԁH')
root_node.extend TreeDesc
root_node.desc = "IƂ݂ǂ\nIƂ"
root_node.image_index = red
root_node.selected_index = green
node = tree_view.items.add_child(root_node, '΁H')
node.extend TreeDesc
node.desc = ''
node.image_index = green
node.selected_index = red
node = tree_view.items.add_child(root_node, '')
node.extend TreeDesc
node.desc = '݂ǂ'
node.image_index = green
node.selected_index = green

form.show

Phi.mainloop


