#!ruby
# Delphi Parser
# author: YOSHIDA Kazuhiro (moriq)
# mailto: moriq@moriq.com

require 'dp/tokenizer'
require 'dp/structure'

class Parser

private

def class_visibility
  case @t.dc_token
  when 'private', 'protected', 'public', 'published'
    @t.next_token
# else
#   raise
  end
end

def list_loop(delimiter)
  for loop_count in 0...1024
    yield
    case @t.dc_token
    when delimiter
      @t.next_token
    else
      break
    end
  end
end

def ident_list
  ret = []
  list_loop(',') { ret.push @t.check(:ident) }
  ret
end

def class_herit
  @t.check '('
  ret = ident_list
  @t.check ')'
  ret
end

def field_decl
  ret = Delphi::Field.new
  ret.ident_list = ident_list
  @t.check(':')
  ret.type = normal_type
  ret
end

def rec_variant
  ret = Delphi::RecVariant.new
  begin
    list_loop(','){
      expr = []
      expr.push @t.check(:ident)
      while true
        case @t.dc_token
        when 'or'
          expr.push @t.next_token
          expr.push @t.check(:ident)
        else
          break
        end
      end
      ret.expr_list.push expr
    }
  rescue
    #
  end
  case @t.dc_token
  when ':'
    @t.next_token
    @t.check '('
    ret.field_list = field_list
    @t.check ')'
  end
  ret
end

def variant_section
  ret = Delphi::Variant.new
  @t.check 'case'
  ret.ident = @t.check(:ident)
  case @t.dc_token
  when ':'
    @t.next_token
    ret.type = type_ident
  end
  @t.check 'of'
  list_loop(';'){ ret.rec_variant_list.push rec_variant }
  ret
end

def field_list
  @d.outputs "### field_list"
  ret = Delphi::FieldList.new
  begin
    list_loop(';'){ ret.field_decl_list.push field_decl }
  rescue
    #
  end
  case @t.dc_token
  when 'case'
    ret.variant = variant_section
  end
  ret
end

def obj_field_list
  @d.outputs "### obj_field_list"
  ret = Delphi::ObjFieldList.new
  list_loop(';') do
    ret.ident_list = ident_list
    @t.check(':')
    ret.type = normal_type
  end
  ret
end

def param
  ret = Delphi::Param.new
  ret.ident_list = ident_list
  case @t.dc_token
  when ':'
    @t.next_token
    ret.type =
    case @t.dc_token
    when 'array'
      array_type = []
      array_type.push @t.next_token
      array_type.push @t.check('of')
      array_type.push \
      case @t.dc_token
      when 'const'
        @t.next_token
      else
        ord_type
      end
      array_type
    when 'string'
      @t.next_token
    when 'file'
      @t.next_token
    else
      normal_type
    end
    case @t.dc_token
    when '='
      @t.next_token
      ret.value = const_expr
    end
  end
  ret
end

def formal_param
  case @t.dc_token
  when 'var', 'const', 'out'
    @t.next_token
  end
  param
end

def formal_param_list
  ret = []
  @t.check '('
  begin
    list_loop(';'){ ret.push formal_param }
  rescue
    #
  end
  @t.check ')'
  ret
end

def directive
  @d.outputs "### directive"
  delim = nil
  case @t.dc_token
  when ';'
    delim = @t.next_token
  end
  ret = []
for loop_count in 0...1024
  case @t.dc_token
  when 'cdecl', 'register', 'dynamic', 'virtual', 'export', 'near', 'far', 'forward', 'override', 'overload', 'pascal', 'reintroduce', 'safecall', 'stdcall', 'varargs', 'local', 'abstract', 'assembler'
    ret.push @t.next_token
  when 'external'
    ret.push @t.next_token
    const_expr
  else
    break
  end
  case @t.dc_token
  when ';'
    delim = @t.next_token
  end
end
    @t.put_token(delim) if delim
  ret
end

def portability_directive
  @d.outputs "### portability_directive"
  delim = nil
  case @t.dc_token
  when ';'
    delim = @t.next_token
  end
  case @t.dc_token
  when 'deprecated', 'library', 'platform'
    @t.next_token
  else
    @t.put_token(delim) if delim
  end
end

def procedure_header
  ret = Delphi::Procedure.new
  @t.check 'procedure'
  ret.ident = @t.check(:ident)
  case @t.dc_token
  when '.'
    @t.next_token
    @t.check(:ident)
    @t.check '='
    @t.check(:ident)  # assign interface method
    return
  when '('
    ret.param_list = formal_param_list
  end
  delim = nil
  case @t.dc_token
  when ';'
    delim = @t.next_token
  end
  case @t.dc_token
  when 'message'
    @t.next_token
    const_expr
  else
    @t.put_token(delim) if delim
  end
  ret.directive = directive
  portability_directive
  ret
end

def function_header
  ret = Delphi::Function.new
  @t.check 'function'
  ret.ident = @t.check(:ident)
  case @t.dc_token
  when '.'
    @t.next_token
    @t.check(:ident)
    @t.check '='
    @t.check(:ident)  # assign interface method
    return
  when '('
    ret.param_list = formal_param_list
  end
  @t.check ':'
  ret.type = normal_type
  ret.directive = directive
  portability_directive
  ret
end

def constructor_header
  ret = Delphi::Constructor.new
  @t.check 'constructor'
  ret.ident = @t.check(:ident)
  case @t.dc_token
  when '('
    ret.param_list = formal_param_list
  end
  ret.directive = directive
  portability_directive
  ret
end

def destructor_header
  ret = Delphi::Destructor.new
  @t.check 'destructor'
  ret.ident = @t.check(:ident)
  case @t.dc_token
  when '('
    ret.param_list = formal_param_list
  end
  ret.directive = directive
  portability_directive
  ret
end

def method_header
  @d.outputs "### method_header"
  case @t.dc_token
  when 'class'
    @t.next_token
    # class method
  end
  case @t.dc_token
  when 'procedure'
    procedure_header
  when 'function'
    function_header
  when 'constructor'
    constructor_header
  when 'destructor'
    destructor_header
  end
end

def prop_param_list
  @t.check '['
  list_loop(';') do
    case @t.dc_token
    when 'var', 'const', 'out'
      @t.next_token
    end
    ident_list
    @t.check ':'
    type_ident
  end
  @t.check ']'
end

def prop_interface
  case @t.dc_token
  when '['
    prop_param_list
  end
  @t.check ':'
  normal_type
end

def prop_list
  @d.outputs "### prop_list"
  ret = Delphi::Property.new
  @t.check 'property'
  ret.ident = @t.check(:ident)
  case @t.dc_token
  when '[', ':'
    ret.interface = prop_interface
  end
  case @t.dc_token
  when 'index'
    @t.next_token
    const_expr
  end
  case @t.dc_token
  when 'read'
    @t.next_token
    type_ident
  end
  case @t.dc_token
  when 'write'
    @t.next_token
    type_ident
  end
  case @t.dc_token
  when 'stored'
    @t.next_token
    type_ident
  end
  case @t.dc_token
  when 'default'
    @t.next_token
    const_expr
  when 'nodefault'
    @t.next_token
  end
  case @t.dc_token
  when 'implements'
    @t.next_token
    list_loop(',') { @t.check(:ident) }
  end
  case @t.dc_token
  when 'readonly', 'writeonly'
    @t.next_token
  end
  case @t.dc_token
  when 'dispid'
    @t.next_token
    const_expr
  end
  delim = nil
  case @t.dc_token
  when ';'
    delim = @t.next_token
  end
  case @t.dc_token
  when 'default'
    @t.next_token
  else
    @t.put_token(delim) if delim
  end
  ret
end

def record_field_list
  @d.outputs "### record_field_list"
  ret = []
  begin
    list_loop(';'){ ret.push field_list }
  rescue
    #
  end
  ret
end

def class_field_list
  @d.outputs "### class_field_list"
  ret = []
  begin
    list_loop(';') do
#     class_visibility
      ret.push obj_field_list
    end
  rescue
    #
  end
  ret
end

def method_list
  @d.outputs "### method_list"
  ret = method_header
  case @t.dc_token
  when 'dispid'
    @t.next_token
    const_expr
  end
  ret
end

def class_method_list
  @d.outputs "### class_method_list"
  ret = []
  begin
    list_loop(';') do
#     class_visibility
      ret.push method_list
    end
  rescue
    #
  end
  ret
end

def class_prop_list
  @d.outputs "### class_prop_list"
  ret = []
  begin
    list_loop(';') do
#     class_visibility
      ret.push prop_list
    end
  rescue
    #
  end
  ret
end

def record_type
  @t.check 'record'
  ret = record_field_list
  @t.check 'end'
  ret
end

def class_type
  @t.check 'class'
  dc = Delphi::Class.new
  case @t.dc_token
  when ';'
    return dc
  when 'of'
    @t.next_token
    cref = Delphi::ClassRef.new
    cref.base = type_ident
    return cref
  when '('
    dc.herit = class_herit
    case @t.dc_token
    when ';'
      return dc
    when 'end'
      @t.next_token
      return dc
    end
  end
  @d.outputs "### class_type " << @t.dc_token
  dc.visibility = class_visibility || 'published'
  for loop_count in 0...1024
    case @t.dc_token
    when 'private', 'protected', 'public', 'published'
      dc.visibility = class_visibility
    when 'procedure', 'function', 'constructor', 'destructor'
      dc.add_methods class_method_list
    when 'property'
      dc.add_props class_prop_list
    when 'end'
      break
    else
      dc.add_fields class_field_list
    end
  end
  @t.check 'end'
  @d.outputs "### leave class_type " << @t.dc_token
  dc
end

def interface_herit
  @t.check '('
  ret = ident_list
  @t.check ')'
  ret
end

def interface_type
  @t.check 'interface'
  case @t.dc_token
  when ';'
    return
  when '('
    interface_herit
    case @t.dc_token
    when ';'
      return
    when 'end'
      @t.next_token
      return
    end
  end
  case @t.dc_token
  when '['
    @t.next_token
    @t.check(:ident)
    @t.check ']'
  end
  for loop_count in 0...1024
    case @t.dc_token
    when 'private', 'protected', 'public', 'published'
      class_visibility
    when 'procedure', 'function', 'constructor', 'destructor'
      class_method_list
    when 'property'
      class_prop_list
    when 'end'
      break
    end
  end
  @t.check 'end'
end

def dispinterface_type
  @t.check 'dispinterface'
  case @t.dc_token
  when ';'
    return
  when '('
    interface_herit
    case @t.dc_token
    when ';'
      return
    when 'end'
      @t.next_token
      return
    end
  end
  case @t.dc_token
  when '['
    @t.next_token
    @t.check(:ident)
    @t.check ']'
  end
  for loop_count in 0...1024
    case @t.dc_token
    when 'private', 'protected', 'public', 'published'
      class_visibility
    when 'procedure', 'function', 'constructor', 'destructor'
      class_method_list
    when 'property'
      class_prop_list
    when 'end'
      break
    end
  end
  @t.check 'end'
end

def pointer_type
  ret = Delphi::PointerType.new
  for loop_count in 0...1024
    case @t.dc_token
    when '^'  # pointer
      ret.ref.push @t.next_token
    else
      break
    end
  end
  ret.type = @t.check(:ident)
end

# def ord_ident
#   @t.check(:ident)
# end

# def subrange_type
#   const_expr
#   @t.check '..'
#   const_expr
# end

def ord_type
  @d.outputs "### ord_type"
  case @t.dc_token
  when '('
    enum_type
  else
    # ord_ident
    # subrange_type
    ord_expr = const_expr
    case @t.dc_token
    when '..'
      @t.next_token
      ret = Delphi::SubRangeType.new
      ret.begin_expr = ord_expr
      ret.end_expr = const_expr
    else
      ret = Delphi::OrdType.new
      ret.expr = ord_expr
    end
    ret
  end
end

def array_type
  ret = Delphi::ArrayType.new
  for loop_count in 0...1024
    case @t.dc_token
    when 'array'
      @t.next_token
      range = []
      case @t.dc_token
      when '['
        @t.next_token
        list_loop(','){ range.push ord_type }
        @t.check ']'
      end
      @t.check 'of'
      ret.range.push range
    end
  end
  ret.type =
  case @t.dc_token
  when 'const'
    @t.next_token
  else
    ord_type
  end
  ret
end

def string_type
  ret = Delphi::StringType.new
  @t.check 'string'
  case @t.dc_token
  when '['
    @t.next_token
    ret.type = ord_type
    @t.check ']'
  end
  ret
end

def enum_type_item
  ret = Delphi::EnumTypeItem.new
  ret.ident = @t.check(:ident)
  case @t.dc_token
  when '='
    @t.next_token
    ret.value = const_expr
  end
  ret
end

def enum_type
  ret = Delphi::EnumType.new
  @t.check '('
  list_loop(','){ ret.items.push enum_type_item }
  @t.check ')'
  ret
end

def file_type
  ret = Delphi::FileType.new
  @t.check 'file'
  case @t.dc_token
  when 'of'
    @t.next_token
    ret.type = type_ident
  end
  ret
end

def set_type
  ret = Delphi::SetType.new
  @t.check 'set'
  @t.check 'of'
  ret.type = ord_type
  ret
end

def procedure_type
  ret = Delphi::ProcedureType.new
  @t.check 'procedure'
  case @t.dc_token
  when '('
    ret.param_list = formal_param_list
  end
  ret
end

def function_type
  ret = Delphi::FunctionType.new
  @t.check 'function'
  case @t.dc_token
  when '('
    ret.param_list = formal_param_list
  end
  @t.check ':'
  ret.type = normal_type
  ret
end

def proc_type
  @d.outputs "### proc_type"
  ret =
  case @t.dc_token
  when 'procedure'
    procedure_type
  when 'function'
    function_type
  end
  case @t.dc_token
  when 'of'
    @t.next_token
    @t.check 'object'
  end
  ret.directive = directive
  portability_directive
  ret
end

def normal_type
  @d.outputs "### normal_type"
  ret = 
  case @t.dc_token
  when 'type'
    @t.next_token
    normal_type
  when 'procedure', 'function'
    proc_type
  when 'class'
    class_type
  when 'interface'
    interface_type
  when 'dispinterface'
    dispinterface_type
  when 'packed'
    @t.next_token
    normal_type
  when 'record'
    record_type
  when 'file'
    file_type
  when 'set'
    set_type
  when '('
    enum_type
  when '^'
    pointer_type
  when 'array'
    array_type
  when 'string'
    string_type
  else
    ord_type
  end
  portability_directive
  ret
end

def type_ident
  @d.outputs "### type_ident"
  ret = []
  list_loop('.'){ ret.push @t.check(:ident) }
  ret
end

def factor
  if /^['$#]/ =~ @t.dc_token
    ret = []
    while /^['$#]/ =~ @t.dc_token
      @d.outputs "### string #{@t.dc_token}"
      ret.push @t.next_token
    end
    return ret
  end
  case @t.dc_token
  when '@', 'not', '+', '-'
    @t.next_token
  end
  if @t.ident?(@t.dc_token)
    ret = @t.check(:ident)
    case @t.dc_token
    when '('  # function call, cast
      @t.next_token
      begin
        list_loop(','){ expr }
      rescue
        #
      end
      @t.check(')')
      return
    when '['
      @t.next_token
      begin
        list_loop(','){ expr }
      rescue
        #
      end
      @t.check ']'
    when '.'
      @t.next_token
      @t.check(:ident)
    end
    case @t.dc_token
    when '^'
      @t.next_token
    end
    return ret
  end
  case @t.dc_token
  when '('
    ## '(' Expression ')' #???
    ret = []
    @t.next_token
    list_loop(';'){
      begin
        list_loop(','){ expr }
      rescue
        #
      end
      case @t.dc_token
      when ':'
        @t.next_token
        expr
      end
    }
    @t.check ')'
    return ret
  when '['
    ## SetConstructor
    ret = []
    @t.next_token
    begin
      list_loop(','){ expr }
    rescue
      #
    end
    @t.check ']'
    return ret
  end
  raise
end

def term
  ret = []
  ret.push factor
  for loop_count in 0...1024
    case @t.dc_token
    when '*', '/', 'div', 'mod', 'and', 'shl', 'shr', 'as'
      ret.push @t.next_token
    when '+', '-', 'or', 'xor'
      ret.push @t.next_token
    when '='
      @d.outputs "### = in term"
    # @t.next_token
      return ret
    when '=', '<>', '<', '>', '<=', '>=', 'in', 'is'
      ret.push @t.next_token
    else
      return ret
    end
    ret.push factor
  end
  ret
end

def expr
  ret = []
  ret.push term
  case @t.dc_token
  when '..'
    ret.push @t.next_token
    ret.push term
    return ret
  end
  ret
end

def const_expr
  expr
end

def uses
  @t.check 'uses'
  ret = []
  for loop_count in 0...1024
    ret.push @t.check(:ident)
    case @t.dc_token
    when ','
      @t.next_token
    when ';'
      @t.next_token
      break
    else
      raise "uses: unknown #{@t.dc_token}"
    end
  end
  ret
end

def const_decl
  ret = Delphi::Const.new
  ret.ident = @t.check(:ident)
  case @t.dc_token
  when ':'
    @t.next_token
    ret.type = normal_type
  end
  @d.outputs "### @t.check = in const_decl"
  @t.check '='
  ret.value = const_expr
  portability_directive
  ret
end

def const_decl_section
  @t.check 'const'
  ret = []
  begin
    list_loop(';'){ ret.push const_decl }
  rescue
    #
  end
  ret
end

def resourcestring_decl_section
  @t.check 'resourcestring'
  ret = []
  begin
    list_loop(';'){ ret.push const_decl }
  rescue
    #
  end
  ret
end

def type_decl
  ret = Delphi::Type.new
  ret.ident = @t.check(:ident)
  @t.check '='
  ret.value = normal_type
  ret.directive = directive
  portability_directive
  ret
end

def type_decl_section
  @t.check 'type'
  ret = []
  begin
    list_loop(';'){ ret.push type_decl }
  rescue
    #
  end
  ret
end

def var_decl
  @d.outputs "### var_decl"
  ret = Delphi::Var.new
  ret.ident_list = ident_list
  @t.check ':'
  ret.type = normal_type
  ret.directive = directive
  case @t.dc_token
  when 'absolute'
    @t.next_token
    ret.absolute = @t.check(:ident)
  when '='
    @t.next_token
    @d.outputs "### = in var_decl"
    ret.value = const_expr
  end
  portability_directive
  ret
end

def var_decl_section
  @t.check 'var'
  ret = []
  begin
    list_loop(';'){ ret.push var_decl }
  rescue
    #
  end
  ret
end

def threadvar_decl_section
  @t.check 'threadvar'
  ret = []
  begin
    list_loop(';'){ ret.push var_decl }
  rescue
    #
  end
  ret
end

def procedure_decl
  @d.outputs "### procedure_decl"
  ret = procedure_header
  @t.check ';'
  ret
end

def function_decl
  @d.outputs "### function_decl"
  ret = function_header
  @t.check ';'
  ret
end

def procedure_decl_section
  ret = []
  case @t.dc_token
  when 'procedure'
    ret.push procedure_decl
  when 'function'
    ret.push function_decl
  end
  ret
end

def interface
  @t.check 'interface'
  di = Delphi::Interface.new
  for loop_count in 0...1024
    case @t.dc_token
    when 'uses'
      di.uses.concat uses
    when 'type'
      di.types.concat type_decl_section
    when 'const'
      di.consts.concat const_decl_section
    when 'resourcestring'
      di.resourcestrings.concat resourcestring_decl_section
    when 'var'
      di.vars.concat var_decl_section
    when 'threadvar'
      di.threadvars.concat threadvar_decl_section
    when 'procedure', 'function'
      di.procedures.concat procedure_decl_section
    else
      break
    end
  end
  di
end

def implementation
  @t.check 'implementation'
end

def unit
begin
  @t.check 'unit'
rescue
  errputs $!.message
  $!.backtrace.each{|i| errputs i}
  return
end
  du = Delphi::Unit.new
  du.ident = @t.check(:ident)
  portability_directive
  @t.check ';'
  du.interface = interface
  implementation
  du
end

def initialize
  @t = Tokenizer.new
end

public

def load(fname)
  @t.load(fname)
end

def parse
  unit
end

def deb=(d)
  @d = d
  @t.deb = d
end

end
