module Delphi
  class Field
    attr_accessor :ident_list, :type
  end

  class RecVariant
    attr_accessor :expr_list, :type, :field_list
    def initialize
      @expr_list = []
    end
  end

  class Variant
    attr_accessor :ident, :type, :rec_variant_list
    def initialize
      @rec_variant_list = []
    end
  end

  class FieldList
    attr_accessor :field_decl_list, :variant
    def initialize
      @field_decl_list = []
    end
  end

  class ObjFieldList
    attr_accessor :ident_list, :type
  end

  class Param
    attr_accessor :ident_list, :type, :value
  end

  class Procedure
    attr_accessor :ident, :param_list, :directive
  end

  class Function
    attr_accessor :ident, :param_list, :type, :directive
  end

  class Constructor
    attr_accessor :ident, :param_list, :directive
  end

  class Destructor
    attr_accessor :ident, :param_list, :directive
  end

  class Property
    attr_accessor :ident, :interface
  end

  class ClassAttr
    attr_accessor :visibility, :spec, :value
    def initialize(visibility, spec, value)
      @visibility = visibility.intern
      @spec = spec
      @value = value
    end
  end

  class Class
    attr_reader :attrs
    attr_accessor :visibility, :herit

    def initialize
      @attrs = []
      @visibility = 'published'
    end

    def add_fields(fields)
      fields.each{|i|
        @attrs.push Delphi::ClassAttr.new(@visibility, :field, i)
      }
    end

    def add_methods(methods)
      methods.each{|i|
        @attrs.push Delphi::ClassAttr.new(@visibility, :method, i)
      }
    end

    def add_props(props)
      props.each{|i|
        @attrs.push Delphi::ClassAttr.new(@visibility, :prop, i)
      }
    end

  end

  class ClassRef
    attr_accessor :base
  end

  class PointerType
    attr_accessor :ref, :type
    def initialize
      @ref = []
    end
  end

  class OrdType
    attr_accessor :expr
  end

  class SubRangeType
    attr_accessor :begin_expr, :end_expr
  end

  class ArrayType
    attr_accessor :range, :type
    def initialize
      @range = []
    end
  end

  class StringType
    attr_accessor :type
  end

  class EnumTypeItem
    attr_accessor :ident, :value
  end

  class EnumType
    attr_accessor :items
    def initialize
      @items = []
    end
  end

  class FileType
    attr_accessor :type
  end

  class SetType
    attr_accessor :type
  end

  class ProcedureType
    attr_accessor :ident, :param_list, :directive
  end

  class FunctionType
    attr_accessor :ident, :param_list, :type, :directive
  end

  class Const
    attr_accessor :ident, :type, :value, :directive
  end

  class Type
    attr_accessor :ident, :value, :directive
  end

  class Var
    attr_accessor :ident_list, :type, :directive, :absolute, :value
  end

  class Interface
    attr_reader :uses, :types, :consts, :resourcestrings, :vars, :threadvars, :procedures
    def initialize
      @uses = []
      @types = []
      @consts = []
      @resourcestrings = []
      @vars = []
      @threadvars = []
      @procedures = []
    end
  end

  class Unit
    attr_accessor :ident, :interface
  end
end

