#!/usr/env ruby -Ks
#-- MemoDialog.rb

require 'phi'
require 'jpeg'
begin ; require "fold" ; rescue Exception ; end

=begin
  MemoDialog W[

  LvVAvvgA͑AC[WA{^w肪\ȃ_CAOB
  {tHggpB

  F
  LvV(String)ƃvvg(String)͕K{B
  ͑́Amemo_text=nil ȂoȂBmemo_text="" ȂoB
  {^̓ftHǵu:okvBw肷ꍇɂ̓{^id͕̔zŎw肷B
  C[W̓pXŎw肷Bimage_pth=nilȂoȂB

  ߂ĺF
  ͑oꍇɂ[mrA̓e]
  ͑oȂꍇɂmr
  mŕA{^idŎw肵ꍇɂ Phi::MR_XXAŎw肵ꍇɂ101+zuԍB

=end

module MemoDialog
module_function
def execute(caption, prompt_text, memo_text=nil, btn_ids=[:ok], image_path=nil,*options)
    font_size=12
    font_name="fixed"
    control_class=nil
    while (opt = options.shift)
      case opt
      when Numeric
        font_size = opt
      when String
        font_name = opt
      when Class
        control_class = opt
      ##when Hash
      else
        raise "invalid option #{opt.inspect}"
      end
    end

    btn_ids = [:ok] unless btn_ids

    form = Phi::Form.new :note, caption
    form.font.name = font_name
    form.font.size = font_size
    form.font.pitch = Phi::FP_FIXED
    form.auto_scroll = false
    form.position = Phi::PO_SCREEN_CENTER

    if image_path
        image = Phi::Image.new form, :image
        image.picture.load(image_path)
        image.set_bounds(8,8,image.picture.width,image.picture.height)
    else
        image = Phi::Label.new form, :image, ''
        image.set_bounds(0,0,0,0)
    end

    prompt = Phi::Memo.new form, :prompt
    prompt.set_bounds(image.right + 0,0,0,0)
    prompt.border_style = 0
    prompt.color = prompt.parent.color
    prompt.read_only = true
    prompt.tab_stop = false
    prompt.word_wrap = false

    if defined? "".fold
      list = []
      prompt_text.split(/\r?\n/).each{|line| line.fold(40){|i| list.push i}}
    else
      list = prompt_text.split(/\r?\n/)
    end
    unless list.empty?
        prompt.text = list.join("\r\n")
        prompt.left+= 8
        prompt.top+= 8
        prompt.width = list.collect{|i| form.canvas.text_width(i)}.max
        n = 0
        list.each{|i| n+= form.canvas.text_height(i)}
        prompt.height = n
    end

    case memo_text
    when Array
        control_class ||= Phi::ListBox
        memo = control_class.new form, :memo
        memo.items.clear
        memo.text = "" if defined? memo.text
        memo_text.each{|n| memo.items.add(n.chomp) }
        memo.left = 8
        memo.top = [image.bottom, prompt.bottom].max + 8
        memo.on_dbl_click = proc{ form.modal_result = Phi::MR_OK}
    when String
        control_class ||= Phi::Memo
        memo = control_class.new form, :memo, memo_text.gsub(/\r?\n/, "\r\n")
        memo.left = 8
        memo.top = [image.bottom, prompt.bottom].max + 8
        memo.scroll_bars = Phi::SS_VERTICAL if defined? memo.scroll_bars
    else
        memo = Phi::Label.new form, :memo, ''
        memo.set_bounds(8,[image.bottom, prompt.bottom].max,0,0)
    end

    panel = Phi::Panel.new form, :panel, ''
    panel.align = Phi::AL_BOTTOM
    panel.bevel_outer = Phi::BV_NONE

    btns = []
    btn_ids.each_with_index do |id,index|
        btn = Phi::Button.new(panel)
        cap = (id.is_a? Symbol) ? id.to_s.upcase : id.to_s
        btn.caption = cap
        name = "MR_#{cap}"
        btn.modal_result = Phi.const_defined?(name) ? Phi.const_get(name) : index+101
        btn.default = [:ok, :yes].include?(id)
        btn.cancel  = [:cancel, :no].include?(id)
        btn.width = [btn.width, form.canvas.text_width(cap)+8].max
        btns.push btn
    end

    btns_space = 8

    unless btns.empty?
        btns_height = btns.collect{|i| i.height}.max
        panel.height = btns_height + btns_space*2
    else
        btns_height = 0
        panel.height = btns_height + btns_space
    end
    form.client_height = memo.bottom + panel.height

    btns_width = 0
    btn_space = 8
    unless btns.empty?
        btns.each{|btn| btns_width+= btn.width}
        btns_width+= btn_space*(btns.size-1)
    end

    memo.width = [prompt.right - memo.left, btns_width, caption.size*form.font.size/2+80].max

    form.client_width = [prompt.right + 8, btns_width + btns_space*2, memo.width+20 ].max

    unless btns.empty?
        btns[0].left = panel.width - btns_width - btns_space
        btns[0].top = 8
        btns[0].anchors = [Phi::AK_TOP, Phi::AK_RIGHT]
    end
    for i in 1...btns.size
        btns[i].left = btns[i-1].right + btn_space
        btns[i].top = 8
        btns[i].anchors = [Phi::AK_TOP, Phi::AK_RIGHT]
    end

    prompt.anchors =
        [Phi::AK_LEFT, Phi::AK_TOP]
    memo.anchors =
        [Phi::AK_LEFT, Phi::AK_TOP, Phi::AK_RIGHT, Phi::AK_BOTTOM]

    mr = form.show_modal

    case memo_text
    when Array
      return mr, nil if mr == Phi::MR_CANCEL || memo.item_index < 0
      return mr, memo.items[memo.item_index]
    when String
      return mr, memo.lines.text if defined? memo.lines
      return mr, memo.text
    else
      return mr
    end
end
end # module

if __FILE__ == $0
    image = File.dirname(File.dirname(Phi::APPLICATION.exe_name))+"/sample/arima.ico"
    ##image = 'c:/program files/apollo/sample/arima.ico'

    caption = "Ruby̖` - ͂߂"
    text = <<MMMM
N͎wւEB
Ruby̎wւB
CƐX̒ɂB   
؁X悭ƁûՂ낮ށvȂǂƏĂBvO~O̐Xɖł܂B肪BǂB
MMMM
    buttons = ["","E","߂","wւ","wւ͂߂"]
    
    p ans = MemoDialog.execute( caption+"(nil)", text , nil , buttons, image )
    p ans = MemoDialog.execute( caption+"(Memo)", text , "" ,  buttons, image )
    p ans = MemoDialog.execute( caption+"(Edit)", text , "" ,  buttons, image, Phi::Edit )

    caption = "Ruby̖` - "
    text = "ĝIĂ"
    items = <<MMMM.to_a
Ruby̎w(1)
^CL(6)
TCy(1)
c(1)
g(10)
NA[X(2)
(10)
}PX(3)
MMMM

    buttons = ["I","g","̂Ă"]
    p ans = MemoDialog.execute( caption+"(LixtBox)", text , items , buttons, image )
    p ans = MemoDialog.execute( caption+"(ComboBox)", text , items , buttons, image, Phi::ComboBox )
end
