require 'phi'

def method_to_s(pi)
  pi[0] =
  '[' <<
    pi[0].collect{|i| Phi::TYPE_INFO['TParamFlag'].enum_name(i)}.join(', ') <<
  ']'
  pi.join("\t")
end

def print_with_tab(lev, s)
  print "\t"*lev, s
end

def print_type_data(ti, lev=0)
  td = ti.type_data
  return if td.nil?
  print_with_tab lev, "=== type_data #{td}\n"
  case ti.kind
  when Phi::TK_INTEGER, Phi::TK_CHAR, Phi::TK_WCHAR
    print_with_tab lev, "ord_type: #{
      Phi::TYPE_INFO['TOrdType'].enum_name(td.ord_type)
    }\n"
    print_with_tab lev, "min_value: #{td.min_value}\n"
    print_with_tab lev, "max_value: #{td.max_value}\n"
  when Phi::TK_ENUMERATION
    print_with_tab lev, "ord_type: #{
      Phi::TYPE_INFO['TOrdType'].enum_name(td.ord_type)
    }\n"
    print_with_tab lev, "min_value: #{td.min_value}\n"
    print_with_tab lev, "max_value: #{td.max_value}\n"
    print_with_tab lev, "base_type: #{td.base_type}\n"
    print_with_tab lev, '[' <<
      (td.min_value..td.max_value).collect{|i| ti.enum_name(i)}.join(', ') <<
    ']' << "\n"
 #  base_type = td.base_type
 #  base_type.use_type_data
 #  print_type_info(base_type, lev+1)
  when Phi::TK_SET
    print_with_tab lev, "ord_type: #{
      Phi::TYPE_INFO['TOrdType'].enum_name(td.ord_type)
    }\n"
    print_with_tab lev, "comp_type: #{td.comp_type}\n"
    comp_type = td.comp_type
    comp_type.use_type_data
    print_type_info(comp_type, lev+1)
  when Phi::TK_FLOAT
    print_with_tab lev, "float_type: #{
      Phi::TYPE_INFO['TFloatType'].enum_name(td.float_type)
    }\n"
  when Phi::TK_STRING
    print_with_tab lev, "max_length: #{td.max_length}\n"
  when Phi::TK_CLASS
    print_with_tab lev, "class_type: #{td.class_type}\n"
    print_with_tab lev, "parent_info: #{td.parent_info}\n"
    print_with_tab lev, "count: #{td.count}\n"
    td.items.each do |pi|
      print_with_tab lev, "name: #{pi.name}\n"
      print_type_info(pi.type_info, lev+1)
    end
    print_with_tab lev, "unit_name: #{td.unit_name}\n"
  when Phi::TK_METHOD
    print_with_tab lev, "method_kind: #{
      Phi::TYPE_INFO['TMethodKind'].enum_name(td.method_kind)
    }\n"
    print_with_tab lev, "count: #{td.count}\n"
    td.items.each do |pi|
      print_with_tab lev+1, "#{method_to_s(pi)}\n"
    end
  when Phi::TK_INT64
    print_with_tab lev, "min_value: #{td.min_value}\n"
    print_with_tab lev, "max_value: #{td.max_value}\n"
  end
end

def print_type_info(ti, lev=0)
  return if ti.nil?
  print_with_tab lev, "=== type_info #{ti}\n"
  print_with_tab lev, "kind: #{
    Phi::TYPE_INFO['TTypeKind'].enum_name(ti.kind)
  }\n"
  print_with_tab lev, "name: #{ti.name}\n"
  print_type_data(ti, lev)
end

def print_prop_info(pi)
  print "=== prop_info #{pi}\n"
  print "name: #{pi.name}\n"
  ti = pi.type_info
  print_type_info(ti)
end

class_name = ARGV.shift || 'Phi::Edit'
print "#{class_name}.type_info\n"
print_type_info eval(class_name).type_info
