#!ruby -Ks

require 'phi'
require 'dialogs'
require 'editor'

DEFAULT_TITLE = ''

class AboutDialog < Phi::Form
  
  def initialize
    super
    self.border_style = Phi::BS_DIALOG
    self.width = 300
    self.height = 180
    self.caption = '̃\tgɂ'

    margin = 15
    w = self.width - margin * 2

    button = Phi::Button.new(self, :button1, 'OK')
    button.modal_result = Phi::MR_OK
    button.width = w
    button.left = margin
    button.top = self.height - margin * 3 - button.height

    label = Phi::Label.new(self, :label1)
    label.caption = "̃XNvg̓t[\tgEFAłB\r\nRɂgB"
    label.width = w
    label.height = button.top - margin * 2
    label.left = margin
    label.top = margin
  end

end

def error_dlg(msg)
  result = Phi::message_dlg(msg, Phi::MT_ERROR, [Phi::MB_YES, Phi::MB_NO, Phi::MB_CANCEL], 0)
  return result
end

def confirm_save
  result = error_dlg('t@CύXĂ܂Bۑ܂?')
  case result
  when Phi::MR_YES
    save_file
    return true
  when Phi::MR_NO
    return true
  when Phi::MR_CANCEL
    return false
  end
end

def save_file
  if $filename.nil?
    dlg = Phi::SaveDialog.new
    dlg.filter = 'ׂẴt@C(*.*)|*|eLXg(*.txt)|*.txt|'
    if dlg.execute
      $filename = dlg.file_name
    end 
  end

  if $filename and Phi::SCREEN.form1.editor1.modified
    Phi::SCREEN.form1.editor1.lines.save($filename)
    Phi::SCREEN.form1.editor1.modified = false    
    Phi::SCREEN.form1.caption = DEFAULT_TITLE + ' ' + $filename
  end
end

def before_exit
  if Phi::SCREEN.form1.editor1.modified
    result = confirm_save
    return result
  end
  return true
end



form = Phi::Form.new(:form1, DEFAULT_TITLE)
editor = Phi::Editor.new(form, :editor1, '')
editor.align = Phi::AL_CLIENT
editor.lines.clear
editor.modified = false
$filename = nil
form.width = 500
form.height = 400

Phi.new_menu(form, :menu1, [
  menu_file = Phi.new_item('t@C(&F)', '', :mi_file).add(
    menu_open = Phi.new_item('J(&O)', 'CTRL+O', :mi_open),
    menu_save = Phi.new_item('ۑ(&S)', 'CTRL+S', :mi_save),
    Phi.new_line,
    menu_exit = Phi.new_item('I(&X)', '', :mi_exit)
  ),
  menu_edit = Phi.new_item('ҏW(&E)', '', :mi_edit).add(
    menu_undo = Phi.new_item('ɖ߂(&U)', 'Ctrl+Z', :mi_undo),
    menu_redo = Phi.new_item('蒼(&R)', 'Ctrl+A', :mi_redo),
    Phi.new_line,
    menu_cut = Phi.new_item('؂(&T)', 'Ctrl+X', :mi_cut),
    menu_copy = Phi.new_item('Rs[(&C)', 'Ctrl+C', :mi_copy),
    menu_paste = Phi.new_item('\t(&P)', 'Ctrl+V', :mi_paste),
    menu_delete = Phi.new_item('폜(&D)', '', :mi_delete),
    Phi.new_line,
    menu_select_all = Phi.new_item('ׂđI(&A)', '', :mi_select_all)
  ),
  menu_help = Phi.new_item('wv(&H)', '', :mi_help).add(
      menu_about = Phi.new_item('̃\tgɂ', '', :mi_about)
  )
])

# menu
menu_open.on_click = proc do
  dlg = Phi::OpenDialog.new
  dlg.filter = 'eLXg(*.txt)|*.txt|ׂẴt@C(*.*)|*|'
  if dlg.execute
    editor.lines.load(dlg.file_name)
    editor.modified = false
  end
end

menu_save.on_click = proc do
  if editor.modified
    save_file
  end
end

menu_exit.on_click = proc do
  form.close
end

menu_undo.on_click = proc do
  if editor.can_undo 
    editor.undo
  end
end

menu_redo.on_click = proc do
  if editor.can_redo 
    editor.redo
  end
end

menu_cut.on_click = proc do
  editor.cut_to_clipboard
end

menu_copy.on_click = proc do 
  editor.copy_to_clipboard
end

menu_paste.on_click = proc do 
  editor.paste_from_clipboard
end

menu_delete.on_click = proc do
  editor.clear_selection
end

menu_select_all.on_click = proc do 
  editor.select_all
end

menu_about.on_click = proc do
  dlg = AboutDialog.new
  dlg.show_modal
end

# other control
form.on_close_query = proc do
  before_exit
end

menu_file.on_click = proc do
  menu_save.enabled = editor.modified
end

menu_edit.on_click = proc do 
  menu_undo.enabled = editor.can_undo
  menu_redo.enabled = editor.can_redo
  menu_cut.enabled = editor.selected
  menu_copy.enabled  = editor.selected 
  menu_delete.enabled = editor.selected 
  menu_paste.enabled = Phi::CLIPBOARD.has_format?(Phi::CF_TEXT)
end

form.show
Phi::mainloop
