unit Rubies;

interface

uses
{$IFDEF LINUX}
  Libc,
{$ENDIF}
{$IFDEF MSWINDOWS}
  Windows,
{$ENDIF}
  SysUtils, st;

resourcestring
  sWrong_num_of_args = 'wrong # of arguments';
  sWrong_arg_type = 'wrong argument type';
  sToo_few_args = 'too few arguments';
  sToo_many_args = 'too many arguments';
  sOut_of_range = 'out of range';

{$IFDEF MSWINDOWS}
const
  NL = #13#10;

{$I ruby\type.pas}

{$I ruby\funcint.pas}
{$I ruby\gvarint.pas}
{$IFDEF PHIEMBED}
{$I ruby\wrapint.pas}
{$ENDIF}
{$I ruby\macroint.pas}
{$ENDIF}

{$IFDEF LINUX}
const
  NL = #10;

{$I ruby/type.pas}

{$I ruby/funcint.pas}
{$I ruby/gvarint.pas}
{$I ruby/wrapint.pas}
{$I ruby/macroint.pas}
{$ENDIF}

{$IFDEF PHIEMBED}
var
  RuntimeRubyDLL: array[0..MAX_PATH] of Char = RubyDLL;
{$ELSE}
const
  PhiDLL = 'phi.so';

function ap_cArray: Tvalue; external PhiDLL;
function ap_cBignum: Tvalue; external PhiDLL;
function ap_mComparable: Tvalue; external PhiDLL;
function ap_cDir: Tvalue; external PhiDLL;
function ap_mEnumerable: Tvalue; external PhiDLL;
function ap_eException: Tvalue; external PhiDLL;
function ap_eSystemExit: Tvalue; external PhiDLL;
function ap_eInterrupt: Tvalue; external PhiDLL;
function ap_eSignal: Tvalue; external PhiDLL;
function ap_eFatal: Tvalue; external PhiDLL;
function ap_eStandardError: Tvalue; external PhiDLL;
function ap_eRuntimeError: Tvalue; external PhiDLL;
function ap_eTypeError: Tvalue; external PhiDLL;
function ap_eArgError: Tvalue; external PhiDLL;
function ap_eIndexError: Tvalue; external PhiDLL;
function ap_eRangeError: Tvalue; external PhiDLL;
function ap_eSecurityError: Tvalue; external PhiDLL;
function ap_eNotImpError: Tvalue; external PhiDLL;
function ap_eNoMemError: Tvalue; external PhiDLL;
function ap_eScriptError: Tvalue; external PhiDLL;
function ap_eNameError: Tvalue; external PhiDLL;
function ap_eSyntaxError: Tvalue; external PhiDLL;
function ap_eLoadError: Tvalue; external PhiDLL;
function ap_eSystemCallError: Tvalue; external PhiDLL;
function ap_mErrno: Tvalue; external PhiDLL;
function ap_cProc: Tvalue; external PhiDLL;
function ap_load_path: Tvalue; external PhiDLL;
function ap_cThread: Tvalue; external PhiDLL;
function ap_cFile: Tvalue; external PhiDLL;
function ap_mFileTest: Tvalue; external PhiDLL;
function ap_mGC: Tvalue; external PhiDLL;
function ap_cHash: Tvalue; external PhiDLL;
function ap_cIO: Tvalue; external PhiDLL;
function ap_eEOFError: Tvalue; external PhiDLL;
function ap_eIOError: Tvalue; external PhiDLL;
function ap_stdin: Tvalue; external PhiDLL;
function ap_stdout: Tvalue; external PhiDLL;
function ap_stderr: Tvalue; external PhiDLL;
function ap_defout: Tvalue; external PhiDLL;
function ap_fs: Tvalue; external PhiDLL;
function ap_output_fs: Tvalue; external PhiDLL;
function ap_rs: Tvalue; external PhiDLL;
function ap_output_rs: Tvalue; external PhiDLL;
function ap_default_rs: Tvalue; external PhiDLL;
function ap_mMath: Tvalue; external PhiDLL;
function ap_cNumeric: Tvalue; external PhiDLL;
function ap_cFloat: Tvalue; external PhiDLL;
function ap_cInteger: Tvalue; external PhiDLL;
function ap_cFixnum: Tvalue; external PhiDLL;
function ap_eZeroDivError: Tvalue; external PhiDLL;
function ap_eFloatDomainError: Tvalue; external PhiDLL;
function ap_mKernel: Tvalue; external PhiDLL;
function ap_cObject: Tvalue; external PhiDLL;
function ap_cModule: Tvalue; external PhiDLL;
function ap_cClass: Tvalue; external PhiDLL;
function ap_cData: Tvalue; external PhiDLL;
function ap_cNilClass: Tvalue; external PhiDLL;
function ap_cTrueClass: Tvalue; external PhiDLL;
function ap_cFalseClass: Tvalue; external PhiDLL;
function ap_cSymbol: Tvalue; external PhiDLL;
function ap_mPrecision: Tvalue; external PhiDLL;
function ap_mProcess: Tvalue; external PhiDLL;
function ap_cRange: Tvalue; external PhiDLL;
function ap_cRegexp: Tvalue; external PhiDLL;
function ap_progname: Tvalue; external PhiDLL;
function ap_argv: Tvalue; external PhiDLL;
function ap_argv0: Tvalue; external PhiDLL;
function ap_cString: Tvalue; external PhiDLL;
function ap_cStruct: Tvalue; external PhiDLL;
function ap_cTime: Tvalue; external PhiDLL;
function ap_errinfo: Tvalue; external PhiDLL;
procedure ap_set_errinfo(v: Tvalue); external PhiDLL;
procedure ap_set_defout(v: Tvalue); external PhiDLL;
procedure ap_set_stdin(v: Tvalue); external PhiDLL;
procedure ap_set_stdout(v: Tvalue); external PhiDLL;
procedure ap_set_stderr(v: Tvalue); external PhiDLL;
function ap_safe_level: Integer; external PhiDLL;
function ap_verbose: Tvalue; external PhiDLL;
function ap_debug: Tvalue; external PhiDLL;
function ap_nerrs: Integer; external PhiDLL;
function ap_sourceline: Integer; external PhiDLL;
function ap_sourcefile: PChar; external PhiDLL;
function ap_trap_immediate: rb_atomic_t; external PhiDLL;
function ap_prohibit_interrupt: Integer; external PhiDLL;
function ap_trap_pending: rb_atomic_t; external PhiDLL;
function ap_thread_critical(i: Integer): Integer; external PhiDLL;
function ap_thread_tick: Integer; external PhiDLL;
function ap_ignorecase: Integer; external PhiDLL;
function ap_ary_ptr(obj: Tvalue): Pvalue; external PhiDLL;
function ap_ary_len(ary: Tvalue): Integer; external PhiDLL;
function ap_ary_aset(ary, index, v: Tvalue): Tvalue; cdecl; external PhiDLL;
function ap_ary_insert(ary, index, v: Tvalue): Tvalue; cdecl; external PhiDLL;
procedure ap_ary_move(ary: Tvalue; CurIndex, NewIndex: Integer); cdecl; external PhiDLL;
function ap_str_ptr(str: Tvalue): PChar; external PhiDLL;
function ap_str_len(str: Tvalue): Integer; external PhiDLL;
function ap_hash_ifnone(hash: Tvalue): Tvalue; external PhiDLL;
function ap_data_get_struct(obj: Tvalue): Pointer; external PhiDLL;
function ap_match_size(match: Tvalue): Integer; external PhiDLL;
function rb_reg_match_m(re, str: Tvalue): Integer; external PhiDLL;
function ap_match_begin(match: Tvalue; i: Integer): Integer; external PhiDLL;
function ap_match_end(match: Tvalue; i: Integer): Integer; external PhiDLL;
{$ENDIF}

implementation

uses uStrUtils;

{$IFDEF MSWINDOWS}
{$I ruby\funcimp.pas}
{$IFDEF PHIEMBED}
{$I ruby\wrapimp.pas}
{$ENDIF}
{$I ruby\macroimp.pas}
{$ENDIF}

{$IFDEF LINUX}
{$I ruby/funcimp.pas}
{$I ruby/wrapimp.pas}
{$I ruby/macroimp.pas}
{$ENDIF}

end.
