unit CalHandle;

interface

uses
  Windows, Classes, Rubies, ComCtrls;

type
  TCalHandle = class(TObject)
  public
    { TDateTimePicker }
    procedure doUserInput(Sender: TObject; const UserString: string; var DateAndTime: TDateTime; var AllowChange: Boolean);
  end;

var
  cDateTimePicker: Tvalue;

implementation

uses Pythia;

{ TCalHandle }

procedure TCalHandle.doUserInput(Sender: TObject; const UserString: string; var DateAndTime: TDateTime; var AllowChange: Boolean);
var
  recv, data: Tvalue;
  ary, ret, val: Tvalue;
begin
  recv := (Sender as TComponent).tag; (* A *)
  if recv = 0 then Exit;
  data := rb_ary_new; (* B *)
  rb_ary_push(data, rb_intern('on_user_input')); (* C *)
  rb_ary_push(data, recv); (* D *)
  ary := rb_ary_new; (* E *)
  rb_ary_push(ary, ap_DateTime(DateAndTime));
  rb_ary_push(ary, ap_bool(AllowChange));
  rb_ary_push(data, ary); (* F *)
  rb_ary_push(data, ap_String(UserString)); (* G *)
  ret := PhiCallProtect(data); (* H *)
  if RTYPE(ret) <> T_ARRAY then Exit; (* I *)
  val := rb_ary_shift(ret);
  DateAndTime := dl_DateTime(val);
  val := rb_ary_shift(ret);
  AllowChange := RTEST(val);
end;

end.
