library cal;

uses Classes, ComCtrls, Rubies, uDefUtils, Pythia, CalHandle;

{$E so}

var
  Handle: TCalHandle;

function ap_cDateTimePicker: Tvalue;
begin
  result := cDateTimePicker;
end;

procedure DateTimePicker_setup(obj: Tvalue; real: TDateTimePicker);
begin
  if @real.OnUserInput = nil then real.OnUserInput := Handle.doUserInput;

//    AssignPropMethod(real, [PhiGetHandle]);
end;

function DateTimePicker_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [PhiGetHandle]);
  result := Qnil;
end;

function DateTimePicker_alloc(This: Tvalue; real: TDateTimePicker): Tvalue;
begin
  result := ChildAlloc(This, real);
  DateTimePicker_setup(result, real);
end;

function ap_iDateTimePicker(real: TDateTimePicker; owner: Tvalue): Tvalue;
begin
  result := DateTimePicker_alloc(cDateTimePicker, real);
  ap_owner(result, owner);
end;

function ap_iDateTimePicker_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDateTimePicker(TDateTimePicker(AControl), owner);
end;

function DateTimePicker_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TDateTimePicker;
begin
  real := TDateTimePicker.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  DateTimePicker_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function DateTimePicker_date_time(This: Tvalue): Tvalue; cdecl;
var
  real: TDateTimePicker;
begin
  real := ap_data_get_struct(This);
  result := ap_DateTime(real.DateTime);
end;

function DateTimePicker_bold_days(This, ary: Tvalue): Tvalue;
var
  real: TDateTimePicker;
  len: Integer;
  ptr: Pvalue;
  Days: array of LongWord;
  MonthBoldInfo: LongWord;
  i: Integer;
begin
  real := ap_data_get_struct(This); (* A *)
  Check_Type(ary, T_ARRAY); (* B *)
  len := ap_ary_len(ary); (* C *)
  ptr := ap_ary_ptr(ary); (* D *)
  SetLength(Days, len); (* E *)
  for i := 0 to len-1 do (* F *)
  begin
    Days[i] := NUM2INT(ptr^); (* G *)
    Inc(ptr);
  end;
  real.BoldDays(Days, MonthBoldInfo); (* H *)
  result := rb_int2inum(MonthBoldInfo); (* I *)
end;

function dl_DateTimePicker(This: Tvalue): TDateTimePicker;
begin
  result := ap_data_get_struct(This);
end;

function DateTimePicker_get_date(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_DateTime(dl_DateTimePicker(This).Date);
end;

function DateTimePicker_set_date(This,v: Tvalue): Tvalue; cdecl;
begin
  result := v;
  dl_DateTimePicker(This).Date := dl_DateTime(v);
end;

function DateTimePicker_get_date_time(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_DateTime(dl_DateTimePicker(This).DateTime);
end;

function DateTimePicker_set_date_time(This,v: Tvalue): Tvalue; cdecl;
begin
  result := v;
  dl_DateTimePicker(This).DateTime := dl_DateTime(v);
end;

function DateTimePicker_get_min_date(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_DateTime(dl_DateTimePicker(This).MinDate);
end;

function DateTimePicker_set_min_date(This,v: Tvalue): Tvalue; cdecl;
begin
  result := v;
  dl_DateTimePicker(This).MinDate := dl_DateTime(v);
end;

function DateTimePicker_get_max_date(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_DateTime(dl_DateTimePicker(This).MaxDate);
end;

function DateTimePicker_set_max_date(This,v: Tvalue): Tvalue; cdecl;
begin
  result := v;
  dl_DateTimePicker(This).MaxDate := dl_DateTime(v);
end;

procedure Init_cal;
begin
  PhiStart;

  Handle := TCalHandle.Create;
  PhiExtentList.Add(Handle);

  DefineConstSetType(ap_mPhi, TypeInfo(TDateTimeKind));
  DefineConstSetType(ap_mPhi, TypeInfo(TDTDateMode));
  DefineConstSetType(ap_mPhi, TypeInfo(TDTDateFormat));
  DefineConstSetType(ap_mPhi, TypeInfo(TDTCalAlignment));
(*
  RegisterClass(TDateTimePicker);
  PhiAllocFuncList.AddObject('TDateTimePicker', @ap_iDateTimePicker_v);
  cDateTimePicker := rb_define_class('DateTimePicker', ap_cWinControl);
  DefineProp(cDateTimePicker, TDateTimePicker);
*)
  cDateTimePicker := DefinePersistentClass(ap_mPhi, TDateTimePicker, ap_cWinControl, ap_iDateTimePicker_v);

  rb_define_method(cDateTimePicker, 'event_handle', @DateTimePicker_event_handle, 1);
  DefineSingletonMethod(cDateTimePicker, 'new', DateTimePicker_new);
  rb_define_method(cDateTimePicker, 'date_time', @DateTimePicker_date_time, 0);

  DefineAttrGet(cDateTimePicker, 'date', DateTimePicker_get_date);
  DefineAttrSet(cDateTimePicker, 'date', DateTimePicker_set_date);
  DefineAttrGet(cDateTimePicker, 'date_time', DateTimePicker_get_date_time);
  DefineAttrSet(cDateTimePicker, 'date_time', DateTimePicker_set_date_time);
  DefineAttrGet(cDateTimePicker, 'min_date', DateTimePicker_get_min_date);
  DefineAttrSet(cDateTimePicker, 'min_date', DateTimePicker_set_min_date);
  DefineAttrGet(cDateTimePicker, 'max_date', DateTimePicker_get_max_date);
  DefineAttrSet(cDateTimePicker, 'max_date', DateTimePicker_set_max_date);
end;

exports
  ap_cDateTimePicker,
  ap_iDateTimePicker,
  Init_cal;

end.
