library PhiDialogs;

uses
  Classes,
{$IFDEF VCL}
  Dialogs,
{$ELSE}
  QDialogs,
{$ENDIF}
  Rubies, uDefUtils,
{$IFDEF PHIEMBED}
  {PhiMainUnit, } uHandle, uAlloc, uProp, uPhi, uConv, uFont, uComponent;
{$ELSE}
  Pythia;
{$ENDIF}

{$E so}
{$LIBPREFIX ''}

var
  cCommonDialog, cOpenDialog, cSaveDialog, cColorDialog, cFontDialog: Tvalue;

//  message_dlg(mesg, dlg_type=MT_CUSTOM, btns=[MB_OK], help_ctx=0, x=-1, y=-1) : Fixnum
function Phi_message_dlg(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  Mesg: string;
  num: Integer;
  DlgType: TMsgDlgType;
  ary: Tvalue;
  Btns: TMsgDlgButtons;
  HelpCtx: Longint;
  len: Integer;
  ptr: Pvalue;
  n: Integer;
  X, Y: Integer;
  ret: Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;

  mesg := dl_String(args[0]);

  DlgType := mtCustom;
  if argc > 1 then
  begin
    num := FIX2INT(args[1]);
    try
      DlgType := TMsgDlgType(num);
    except
      ap_raise(ap_eArgError, sOut_of_range);
    end;
  end;

  if argc > 2 then
  begin
    ary := args[2];
    Check_Type(ary, T_ARRAY);
    len := ap_ary_len(ary);
    ptr := ap_ary_ptr(ary);
    Btns := [];
    while len > 0 do
    begin
      n := FIX2INT(ptr^);
      try
        Include(Btns, TMsgDlgBtn(n));
      except
        ap_raise(ap_eIndexError, sOut_of_range);
      end;
      Dec(len);
      Inc(ptr);
    end;
  end
  else
    Btns := [mbOK]
  ;

  if argc > 3 then
    HelpCtx := INT2FIX(args[3])
  else
    HelpCtx := 0
  ;

  if argc > 4 then
    X := INT2FIX(args[4])
  else
    X := -1
  ;

  if argc > 5 then
    Y := INT2FIX(args[5])
  else
    Y := -1
  ;

  ret := MessageDlgPos(mesg, DlgType, Btns, HelpCtx, X, Y);
  result := INT2FIX(ret);
end;

function Phi_input_box(This, cap, prompt, v: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(InputBox(dl_String(cap), dl_String(prompt), dl_String(v)));
end;

function Phi_input_query(This, cap, prompt, v: Tvalue): Tvalue; cdecl;
var
  S: string;
begin
  S := dl_String(v);
  result := rb_ary_new;
  rb_ary_push(result, ap_bool(InputQuery(dl_String(cap), dl_String(prompt), S)));
  rb_ary_push(result, ap_String(S));
end;

procedure OpenDialog_setup(obj: Tvalue; real: TOpenDialog);
begin
//
end;

function OpenDialog_alloc(This: Tvalue; real: TOpenDialog): Tvalue;
begin
  result := ChildAlloc(This, real);
  OpenDialog_setup(result, real);
end;

function ap_iOpenDialog(real: TOpenDialog; owner: Tvalue): Tvalue;
begin
  result := OpenDialog_alloc(cOpenDialog, real);
  ap_owner(result, owner);
end;

function ap_iOpenDialog_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iOpenDialog(TOpenDialog(obj), owner);
end;

function OpenDialog_new(This: Tvalue): Tvalue; cdecl;
var
  real: TOpenDialog;
begin
  real := TOpenDialog.Create(nil);
  result := CompoAlloc(This, real);
//    AssignPropMethod(real, [PhiGetHandle]);
  ap_obj_call_init(result, 0, nil);
end;

function OpenDialog_execute(This: Tvalue): Tvalue; cdecl;
var
  real: TOpenDialog;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.Execute);
end;

function OpenDialog_files(This: Tvalue): Tvalue; cdecl;
var
  real: TOpenDialog;
begin
  real := ap_data_get_struct(This);
  result := ap_iStrings(real.files,This);
end;

procedure SaveDialog_setup(obj: Tvalue; real: TSaveDialog);
begin
//
end;

function SaveDialog_alloc(This: Tvalue; real: TSaveDialog): Tvalue;
begin
  result := ChildAlloc(This, real);
  SaveDialog_setup(result, real);
end;

function ap_iSaveDialog(real: TSaveDialog; owner: Tvalue): Tvalue;
begin
  result := SaveDialog_alloc(cSaveDialog, real);
  ap_owner(result, owner);
end;

function ap_iSaveDialog_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iSaveDialog(TSaveDialog(obj), owner);
end;

function SaveDialog_new(This: Tvalue): Tvalue; cdecl;
var
  real: TSaveDialog;
begin
  real := TSaveDialog.Create(nil);
  result := CompoAlloc(This, real);
//    AssignPropMethod(real, [PhiGetHandle]);
  ap_obj_call_init(result, 0, nil);
end;

function SaveDialog_execute(This: Tvalue): Tvalue; cdecl;
var
  real: TSaveDialog;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.Execute);
end;

function ColorDialog_new(This: Tvalue): Tvalue; cdecl;
var
  real: TColorDialog;
begin
  real := TColorDialog.Create(nil);
  result := CompoAlloc(This, real);
//    AssignPropMethod(real, [PhiGetHandle]);
  ap_obj_call_init(result, 0, nil);
end;

function ColorDialog_execute(This: Tvalue): Tvalue; cdecl;
var
  real: TColorDialog;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.Execute);
end;

function FontDialog_new(This: Tvalue): Tvalue; cdecl;
var
  real: TFontDialog;
begin
  real := TFontDialog.Create(nil);
  result := CompoAlloc(This, real);
  rb_iv_set(result, '@font', ap_iFont(real.Font, This));
//    AssignPropMethod(real, [PhiGetHandle]);
  ap_obj_call_init(result, 0, nil);
end;

function FontDialog_execute(This: Tvalue): Tvalue; cdecl;
var
  real: TFontDialog;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.Execute);
end;

procedure Init_dialogs;
begin
  PhiStart;

  DefineConstSetType(ap_mPhi, TypeInfo(TMsgDlgBtn));
  DefineConstSetType(ap_mPhi, TypeInfo(TMsgDlgType));
{$IFDEF VCL}
  DefineConstSetType(ap_mPhi, TypeInfo(TFontDialogOption));
{$ENDIF}
  DefineConstSetType(ap_mPhi, TypeInfo(TOpenOption));

  DefineModuleFunction(ap_mPhi, 'message_dlg', Phi_message_dlg);
  rb_define_module_function(ap_mPhi, 'input_box', @Phi_input_box, 3);
  rb_define_module_function(ap_mPhi, 'input_query', @Phi_input_query, 3);

{$IFDEF VCL}
  cCommonDialog := DefinePersistentClass(ap_mPhi, TCommonDialog, ap_cComponent, nil);
{$ELSE}
  cCommonDialog := DefinePersistentClass(ap_mPhi, TQtDialog, ap_cComponent, nil);
{$ENDIF}

  cOpenDialog := DefinePersistentClass(ap_mPhi, TOpenDialog, cCommonDialog, ap_iOpenDialog_v);
  rb_define_singleton_method(cOpenDialog, 'new', @OpenDialog_new, 0);
  rb_define_method(cOpenDialog, 'execute', @OpenDialog_execute, 0);
  rb_define_method(cOpenDialog, 'files', @OpenDialog_files, 0);

  cSaveDialog := DefinePersistentClass(ap_mPhi, TSaveDialog, cCommonDialog, ap_iSaveDialog_v);
  rb_define_singleton_method(cSaveDialog, 'new', @SaveDialog_new, 0);
  rb_define_method(cSaveDialog, 'execute', @SaveDialog_execute, 0);

  cColorDialog := DefinePersistentClass(ap_mPhi, TColorDialog, cCommonDialog, nil);
  rb_define_singleton_method(cColorDialog, 'new', @ColorDialog_new, 0);
  rb_define_method(cColorDialog, 'execute', @ColorDialog_execute, 0);

  cFontDialog := DefinePersistentClass(ap_mPhi, TFontDialog, cCommonDialog, nil);
  rb_define_singleton_method(cFontDialog, 'new', @FontDialog_new, 0);
  rb_define_method(cFontDialog, 'execute', @FontDialog_execute, 0);
end;

exports
  Init_dialogs;

end.
