unit uFountainBracketCollection;

interface

uses
  Rubies, heFountain;

var
  cFountainBracketCollection: Tvalue;

function ap_iFountainBracketCollection(real: TFountainBracketCollection; owner: Tvalue): Tvalue;
procedure Init_FountainBracketCollection;

implementation

uses
  uDefUtils, Pythia, uFountainBracketItem, uFountain, uEditor;

function FountainBracketCollection_alloc(klass: Tvalue; real: TFountainBracketCollection): Tvalue;
begin
  result := TmpAlloc(klass, real);
  Collection_setup(result, real);
end;

function ap_iFountainBracketCollection(real: TFountainBracketCollection; owner: Tvalue): Tvalue;
begin
  result := FountainBracketCollection_alloc(cFountainBracketCollection, real);
  ap_owner(result, owner);
end;

function ap_iFountainBracketCollection_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iFountainBracketCollection(TFountainBracketCollection(AControl), owner)
end;

procedure Init_FountainBracketCollection;
begin
  cFountainBracketCollection := DefinePersistentClass(ap_mPhi, TFountainBracketCollection, ap_cCollection, ap_iFountainBracketCollection_v);
  SetCollectionItemClass(cFountainBracketCollection, 'TFountainBracketItem');
end;

end.
