library socket;

uses
  SysUtils, Classes, Controls, Psock,
  Rubies, uDefUtils,
{$IFDEF PHIEMBED}
  {PhiMainUnit, }uHandle, uProp, uPhi, uComponent,
{$ELSE}
  Pythia,
{$ENDIF}
  SocketHandle;

{$E so}

var
  Handle: TSocketHandle;

function ap_cSocket: Tvalue;
begin
  result := cSocket;
end;

function SocketHandle: TSocketHandle;
begin
  result := Handle;
end;

procedure Socket_setup(obj: Tvalue; real: TPowerSock);
begin
  if @real.OnConnect = nil then real.OnConnect := SocketHandle.doConnect;
  if @real.OnDisconnect  = nil then real.OnDisconnect := SocketHandle.doDisconnect;
  if @real.OnPacketRecvd = nil then real.OnPacketRecvd := handle.doPacketRecv ;
  if @real.OnPacketSent  = nil then real.OnPacketSent  := handle.doPacketSent ;
end;

function Socket_connected(This: Tvalue): Tvalue; cdecl;
var
  real: TPowerSock;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.Connected);
end;

function Socket_connect(This: Tvalue): Tvalue; cdecl;
var
  real: TPowerSock;
begin
  real := ap_data_get_struct(This);
  try
    real.Connect;
    Handle.doSuccess(real, 'connect');
  except
    Handle.doFailure(real, 'connect');
  end;
  result := This;
end;

function Socket_Disconnect(This: Tvalue): Tvalue; cdecl;
var
  real: TPowerSock;
begin
  real := ap_data_get_struct(This);
  try
    real.Disconnect;
    Handle.doSuccess(real, 'disconnect');
  except
    Handle.doFailure(real, 'disconnect');
  end;
  result := This;
end;

function Socket_abort(This: Tvalue): Tvalue; cdecl;
var
  real: TPowerSock;
begin
  real := ap_data_get_struct(This);
  try
    real.Abort;
    Handle.doSuccess(real, 'abort');
  except
    Handle.doFailure(real, 'abort');
  end;
  result := This;
end;

function Socket_get_bytes_recv(This: Tvalue): Tvalue; cdecl;
var
  real: TPowerSock;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.BytesRecvd);
end;

function Socket_get_bytes_sent(This: Tvalue): Tvalue; cdecl;
var
  real: TPowerSock;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.BytesSent);
end;

function Socket_get_bytes_total(This: Tvalue): Tvalue; cdecl;
var
  real: TPowerSock;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.BytesTotal);
end;

procedure Init_socket; cdecl;
begin
  if ap_mPhi = 0 then ap_loaderror('undefined Phi module');

  Handle := TSocketHandle.Create;
  PhiExtentList.Add(Handle);

  cSocket := DefinePersistentClass(ap_mPhi, TPowersock, ap_cPersistent, nil);

  rb_define_method(cSocket, 'abort', @Socket_abort, 0);
  rb_define_method(cSocket, 'connected', @Socket_connected, 0);
  rb_define_method(cSocket, 'connect', @Socket_connect, 0);
  rb_define_method(cSocket, 'disconnect', @Socket_disconnect, 0);
  DefineAttrGet(cSocket, 'bytes_recv', Socket_get_bytes_recv);
  DefineAttrGet(cSocket, 'bytes_sent', Socket_get_bytes_sent);
  DefineAttrGet(cSocket, 'bytes_total', Socket_get_bytes_total);

  rb_iv_set(cSocket, '@events', rb_hash_new);
  DefineModuleAttrMethod(cSocket, 'on_packet_recv');
  DefineModuleAttrMethod(cSocket, 'on_packet_sent');
end;

exports
  ap_cSocket,
  SocketHandle,
  Socket_setup,
  Init_socket;

end.
