unit uIdLogDebug;

interface

uses Classes, Rubies;

var
  cIdLogDebug: Tvalue;

function ap_cIdLogDebug: Tvalue;
function ap_iIdLogDebug(real: TIdLogDebug; owner: Tvalue): Tvalue;
procedure Init_IdLogDebug;

implementation

uses
  SysUtils, uDefUtils, Pythia, IdLogDebug, IdHandle, uIndy, uIdLogBase;

function ap_cIdLogDebug: Tvalue;
begin
  result := cIdLogDebug;
end;

procedure IdLogDebug_setup(obj: Tvalue; real: TIdLogDebug);
begin
  ap_set_child_attr_module(obj);
end;

function IdLogDebug_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function IdLogDebug_alloc(This: Tvalue; real: TIdLogDebug): Tvalue;
begin
  result := ChildAlloc(This, real);
  IdLogDebug_setup(result, real);
end;

function ap_iIdLogDebug(real: TIdLogDebug; owner: Tvalue): Tvalue;
begin
  result := IdLogDebug_alloc(cIdLogDebug, real);
  ap_owner(result, owner);
end;

function ap_iIdLogDebug_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iIdLogDebug(TIdLogDebug(obj), owner);
end;

function IdLogDebug_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TIdLogDebug;
begin
  real := TIdLogDebug.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  IdLogDebug_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_IdLogDebug;
begin
//  cIdLogDebug := rb_define_class_under(mIndy, 'IdLogDebug', cIdLogBase);
//  DefineProp(cIdLogDebug, TIdLogDebug);
  cIdLogDebug := DefinePersistentClass(mIndy, TIdLogDebug, cIdLogBase, ap_iIdLogDebug_v);
  DefineSingletonMethod(cIdLogDebug, 'new', IdLogDebug_new);
  rb_define_method(cIdLogDebug, 'event_handle', @IdLogDebug_event_handle, 1);
end;

end.
