library mci;

uses
  SysUtils,
  Classes,
  Controls,
  Rubies,
  Pythia,
  uStrUtils,
  uDefUtils,
  Windows,
  MMSystem,
  MPlayer,
  MCIHandle;

{$E so}

var
  Handle: TMCIHandle;

procedure MediaPlayer_setup(obj: Tvalue; real: TMediaPlayer);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));

  ap_set_child_attr_module(obj);

  if @real.OnNotify = nil then real.OnNotify := Handle.doNotify;
  if @real.OnClick = nil then real.OnClick := Handle.doClick;
  if @real.OnPostClick = nil then real.OnPostClick := Handle.doPostClick;

//    AssignPropMethod(real, [PhiGetHandle]);
end;

function MediaPlayer_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [PhiGetHandle]);
  result := Qnil;
end;

function MediaPlayer_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TMediaPlayer;
begin
  real := TMediaPlayer.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  MediaPlayer_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function MediaPlayer_open(This: Tvalue): Tvalue; cdecl;
var
  real: TMediaPlayer;
begin
  real := ap_data_get_struct(This);
  real.Open;
  result := This;
end;

function MediaPlayer_play(This: Tvalue): Tvalue; cdecl;
var
  real: TMediaPlayer;
begin
  real := ap_data_get_struct(This);
  real.Play;
  result := This;
end;

function MediaPlayer_close(This: Tvalue): Tvalue; cdecl;
var
  real: TMediaPlayer;
begin
  real := ap_data_get_struct(This);
  real.Close;
  result := This;
end;

function MediaPlayer_eject(This: Tvalue): Tvalue; cdecl;
var
  real: TMediaPlayer;
begin
  real := ap_data_get_struct(This);
  real.Eject;
  result := This;
end;

function Win_play_sound(This, name, handle, sound: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(PlaySound(PChar(dl_String(name)), FIX2INT(handle), NUM2INT(sound)));
end;

procedure Init_mci; cdecl;
begin
  if ap_mPhi = 0 then ap_loaderror('undefined Phi module');

  Handle := TMCIHandle.Create;
  PhiExtentList.Add(Handle);

  DefineConstSetType(ap_mPhi, TypeInfo(TMPDeviceTypes));

  rb_eMCIDeviceError := rb_define_class_under(ap_mPhi, 'MCIDeviceError', ap_eStandardError);

  cMediaPlayer := DefinePersistentClass(ap_mPhi, TMediaPlayer, ap_cWinControl, nil);

  rb_define_method(cMediaPlayer, 'event_handle', @MediaPlayer_event_handle, 1);
  DefineSingletonMethod(cMediaPlayer, 'new', MediaPlayer_new);

  rb_define_method(cMediaPlayer, 'open', @MediaPlayer_open, 0);
  rb_define_method(cMediaPlayer, 'play', @MediaPlayer_play, 0);
  rb_define_method(cMediaPlayer, 'close', @MediaPlayer_close, 0);
  rb_define_method(cMediaPlayer, 'eject', @MediaPlayer_eject, 0);

  ap_define_const(ap_mPhi, 'SND_ASYNC', INT2FIX(SND_ASYNC));

  rb_define_module_function(ap_mPhi, 'play_sound', @Win_play_sound, 3);
end;

exports
  Init_mci;

end.
