library mozilla;

(*
needs for compile
  ftp://ftp.mozilla.org/pub/mozilla/nightly/
how to install
  http://www02.so-net.ne.jp/~rando/mozilla/
*)

uses
  Classes, ActiveX, MOZILLACONTROLLib_TLB,
  Rubies, uDefUtils, Pythia, MozillaBrowserHandle;

{$E so}

var
  Handle: TMozillaBrowserHandle;

function ap_cMozillaBrowser: Tvalue;
begin
  result := cMozillaBrowser;
end;

procedure MozillaBrowser_setup(obj: Tvalue; real: TMozillaBrowser);
begin
//
end;

function MozillaBrowser_alloc(This: Tvalue; real: TMozillaBrowser): Tvalue;
begin
  result := ChildAlloc(This, real);
  MozillaBrowser_setup(result, real);
end;

function ap_iMozillaBrowser(real: TMozillaBrowser; owner: Tvalue): Tvalue;
begin
  result := MozillaBrowser_alloc(cMozillaBrowser, real);
  ap_owner(result, owner);
end;

function ap_iMozillaBrowser_v(var AControl; owner: Tvalue): TValue;
begin
  Result := ap_iMozillaBrowser(TMozillaBrowser(AControl), owner);
end;

function MozillaBrowser_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TMozillaBrowser;
begin
  real := TMozillaBrowser.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  MozillaBrowser_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function MozillaBrowser_navigate(This, v: TValue): TValue; cdecl;
var
  real: TMozillaBrowser;
begin
  real := ap_data_get_struct(This);
  real.Navigate(dl_String(v));
  Result := This;
end;

function MozillaBrowser_navigate2(This, v: TValue): TValue; cdecl;
var
  real: TMozillaBrowser;
  url: OleVariant;
begin
  real := ap_data_get_struct(This);
  url := dl_Variant(v);
  real.Navigate2(url);
  Result := This;
end;

function MozillaBrowser_go_home(This: TValue): TValue; cdecl;
var
  real: TMozillaBrowser;
begin
  real := ap_data_get_struct(This);
  real.GoHome;
  Result := This;
end;

function MozillaBrowser_go_forward(This: TValue): TValue; cdecl;
var
  real: TMozillaBrowser;
begin
  real := ap_data_get_struct(This);
  real.GoForward;
  Result := This;
end;

function MozillaBrowser_go_back(This: TValue): TValue; cdecl;
var
  real: TMozillaBrowser;
begin
  real := ap_data_get_struct(This);
  real.GoBack;
  Result := This;
end;

function MozillaBrowser_go_search(This: TValue): TValue; cdecl;
var
  real: TMozillaBrowser;
begin
  real := ap_data_get_struct(This);
  real.GoSearch;
  Result := This;
end;

function MozillaBrowser_refresh(This: TValue): TValue; cdecl;
var
  real: TMozillaBrowser;
begin
  real := ap_data_get_struct(This);
  real.Refresh;
  Result := This;
end;

function MozillaBrowser_refresh2(argc: Integer; argv: Pointer; This: TValue): TValue; cdecl;
var
  args: array of TValue;
  real: TMozillaBrowser;
  level: OleVariant;
begin
  real := ap_data_get_struct(This);
  case argc of
  0:
    real.Refresh2;
  1:
    begin
      SetLength(args, argc);
      args := argv;
      level := dl_Variant(args[0]);
      real.Refresh2(level);
    end;
  else
    ap_raise(ap_eArgError, sToo_few_args);
  end;
  Result := This;
end;

procedure Init_mozilla;
begin
  if ap_mPhi = 0 then ap_loaderror('undefined Phi module');

  Handle := TMozillaBrowserHandle.Create;
  PhiExtentList.Add(Handle);

  cMozillaBrowser := DefinePersistentClass(ap_mPhi, TMozillaBrowser, ap_cWinControl, ap_iMozillaBrowser_v);
  DefineSingletonMethod(cMozillaBrowser, 'new', MozillaBrowser_new);

  rb_define_method(cMozillaBrowser, 'navigate', @MozillaBrowser_navigate, 1);
  rb_define_method(cMozillaBrowser, 'navigate2', @MozillaBrowser_navigate2, 1);
  rb_define_method(cMozillaBrowser, 'go_home', @MozillaBrowser_go_home, 0);
  rb_define_method(cMozillaBrowser, 'go_forward', @MozillaBrowser_go_forward, 0);
  rb_define_method(cMozillaBrowser, 'go_back', @MozillaBrowser_go_back, 0);
  rb_define_method(cMozillaBrowser, 'go_search', @MozillaBrowser_go_search, 0);
  rb_define_method(cMozillaBrowser, 'refresh', @MozillaBrowser_refresh, 0);
  rb_define_method(cMozillaBrowser, 'refresh2', @MozillaBrowser_refresh2, -1);
end;

exports
  ap_cMozillaBrowser,
  MozillaBrowser_alloc,
  Init_mozilla;

var
  SaveExit: Pointer;

procedure LibExit;
begin
  CoUninitialize;
  ExitProc := SaveExit;
end;

begin
  SaveExit := ExitProc;
  ExitProc := @LibExit;
  CoInitialize(nil);
end.

