unit uPropGridItem;

interface

uses
  Rubies, HPropGrid;

procedure Init_PropGridItem;
function ap_cPropGridItem: Tvalue;
function ap_iPropGridItem(real: TPropGridItem; owner: Tvalue): Tvalue;

implementation

uses
  SysUtils, Classes, Pythia, uDefUtils, uPGrid;

var
  cPropGridItem: Tvalue;

function ap_cPropGridItem: Tvalue;
begin
  result := cPropGridItem;
end;

procedure PropGridItem_setup(obj: Tvalue; real: TPropGridItem);
begin
//  AssignPropMethod(real, [PGridGetHandle]);
//  real.OnDrawCell := nil;
//  real.OnDrawItem := nil;
  rb_iv_set(obj, '@pick_list', ap_iStrings(real.PickList, obj));
  rb_iv_set(obj, '@events', rb_hash_new);
  real.Data := Pointer(obj);
end;

function PropGridItem_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [PGridGetHandle]);
  result := Qnil;
end;

function PropGridItem_alloc(This: Tvalue; real: TPropGridItem): Tvalue;
begin
  result := TmpAlloc(This, real);
  PropGridItem_setup(result, real);
end;

function ap_iPropGridItem(real: TPropGridItem; owner: Tvalue): Tvalue;
begin
  result := PropGridItem_alloc(cPropGridItem, real);
  ap_owner(result, owner);
end;

function ap_iPropGridItem_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iPropGridItem(TPropGridItem(AControl), owner);
end;

function PropGridItem_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItem;
begin
  real := TPropGridItem.Create(nil);
  result := ObjAlloc(This, real);
  PropGridItem_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function PropGridItem_get_index(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItem;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Index);
end;

function PropGridItem_get_has_children(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItem;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.HasChildren);
end;

function PropGridItem_set_data(This, obj: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItem;
begin
  real := ap_data_get_struct(This);
  real.Data := ap_data_get_struct(obj);
  result := This;
end;

function PropGridItem_get_data(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItem;
begin
  real := ap_data_get_struct(This);
  result := TmpAlloc(This, real.Data);
  // setup͕svH
  ap_owner(result, This);
end;

function PropGridItem_assign(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItem;
  source: TPersistent;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TPersistent, source);
  real.Assign(source);
  result := v;
end;

function PropGridItem_get_name_path(This: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItem;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.GetNamePath);
end;

procedure Init_PropGridItem;
begin
  cPropGridItem := DefinePersistentClass(ap_mPhi, TPropGridItem, ap_cCollectionItem, ap_iPropGridItem_v);
  rb_define_method(cPropGridItem, 'event_handle', @PropGridItem_event_handle, 1);
  DefineSingletonMethod(cPropGridItem, 'new', @PropGridItem_new);

  DefineAttrGet(cPropGridItem, 'has_children', @PropGridItem_get_has_children);
//  DefineAttrGet(cPropGridItem, 'index', @PropGridItem_get_index);
//  DefineAttrGet(cPropGridItem, 'data', PropGridItem_get_data);
//  DefineAttrSet(cPropGridItem, 'data', PropGridItem_set_data);
  rb_define_method(cPropGridItem, 'assign', @PropGridItem_assign, 1);
  rb_define_method(cPropGridItem, 'get_name_path', @PropGridItem_get_name_path, 0);
end;

end.
