library RDB;

uses
  SysUtils, Classes, Rubies, Pythia,
{$IFDEF VCL}
  Graphics, DBTables, DBGrids, DBCtrls, 
{$ELSE}
  QGraphics,
{$ENDIF}
  DB, RDBHandle,
  uRDB,
  uFieldDef,
  uIndexDef,
  uField,
  uParam,
  uDataSource,
  uDataSet,
  uDataSetProvider,
{$IFDEF VCL}
  uDatabase,
  uTable,
  uQuery,
  uStoredProc,
  uClientDataSet,
  uSession,
  uSessionList,
{$ENDIF}
  uSQLConnection,
  uSQLDataSet,
  uSQLTable,
  uSQLQuery,
  uSQLStoredProc,
  uSQLClientDataSet,
{$IFDEF VCL}
  uProperty,
  uParameter,
  uADOConnection,
  uADODataSet,
  uADOTable,
  uADOQuery,
  uADOStoredProc,
{$ENDIF}
  uColumn,
  uDBGrid,
{$IFDEF VCL}
  uDBCtrlGrid,
{$ENDIF}
  uDBNavigator,
  uDBEdit,
  uDBMemo;

{$E so}

procedure Init_rdb;
begin
  if ap_mPhi = 0 then ap_loaderror('undefined Phi module');

  Handle := TRDBHandle.Create;
  PhiExtentList.Add(Handle);

  mRDB := rb_define_module('RDB');

  ap_eDatabaseError := rb_define_class_under(mRDB, 'DatabaseError', ap_eStandardError);

  Init_FieldDef;
  Init_IndexDef;
  Init_Param;
  Init_Field;
  Init_DataSource;
  Init_DataSet;
  Init_DataSetProvider;
{$IFDEF VCL}
  Init_Database;
  Init_Table;
  Init_Query;
  Init_StoredProc;
  Init_ClientDataSet;
  Init_Session;
  Init_SessionList;
{$ENDIF}
  Init_SQLConnection;
  Init_SQLDataSet;
  Init_SQLTable;
  Init_SQLQuery;
  Init_SQLStoredProc;
  Init_SQLClientDataSet;
{$IFDEF VCL}
  Init_Property;
  Init_Parameter;
  Init_ADOConnection;
  Init_ADODataSet;
  Init_ADOTable;
  Init_ADOQuery;
  Init_ADOStoredProc;
{$ENDIF}
  Init_Column;
  Init_DBGrid;
{$IFDEF VCL}
  Init_DBCtrlGrid;
{$ENDIF}
  Init_DBNavigator;
  Init_DBEdit;
  Init_DBMemo;
end;

exports
  Init_rdb;

exports
  ap_cDataSource,
  ap_iDataSource;

{$IFDEF VCL}
exports
  ap_cDatabase,
  ap_iDatabase;
{$ENDIF}

exports
  RDBGetHandle;

{$IFDEF VCL}
exports
  ap_cSession,
  ap_vSession;

exports
  ap_cSessionList,
  ap_vSessionList;

exports
  ap_cTable,
  ap_iTable;
{$ENDIF}

exports
  ap_cSQLConnection,
  ap_iSQLConnection;

var
  SaveExit: Pointer;

procedure LibExit;
begin
{$IFDEF VCL}
  Session.Free;
  Session := nil;
{$ENDIF}
  ExitProc := SaveExit;
end;

begin
  SaveExit := ExitProc;
  ExitProc := @LibExit;
end.
