unit uADODataSet;

interface

uses Rubies, ADODB;

var
  cADODataSet: Tvalue;

function dl_ADODataSet(v: Tvalue): TADODataSet;
function ap_cADODataSet: Tvalue;
function ap_iADODataSet(real: TADODataSet; owner: Tvalue): Tvalue;
procedure Init_ADODataSet;

implementation

uses
  SysUtils, Classes,
{$IFDEF VCL}
  Graphics,
{$ELSE}
  QGraphics,
{$ENDIF}
  TypInfo,
  uDefUtils, Pythia,
  RDBHandle, uRDB, uDataSet, uIndexDef, uProperty;

function dl_ADODataSet(v: Tvalue): TADODataSet;
begin
//  result := ap_data_get_struct(This);
  ap_data_get_object(v, TADODataSet, Result);
end;

function ap_cADODataSet: Tvalue;
begin
  result := cADODataSet;
end;

procedure ADODataSet_setup(obj: Tvalue; real: TADODataSet);
begin
  DataSet_setup(obj, real);
end;

function ADODataSet_alloc(This: Tvalue; real: TADODataSet): Tvalue;
begin
  result := ChildAlloc(This, real);
  ADODataSet_setup(result, real);
end;

function ap_iADODataSet(real: TADODataSet; owner: Tvalue): Tvalue;
begin
  result := ADODataSet_alloc(cADODataSet, real);
  ap_owner(result, owner);
end;

function ap_iADODataSet_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iADODataSet(TADODataSet(obj), owner);
end;

function ADODataSet_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
begin
  real := TADODataSet.Create(nil);
  result := DataSet_alloc1(This, real);
  DataSet_setup(result, real);

  ap_obj_call_init(result, argc, argv);
end;

function ADODataSet_clone(This, v: Tvalue): Tvalue; cdecl;
var
  real: TCustomADODataSet;
begin
  real := ap_data_get_struct(This);
  real.Clone(dl_ADODataSet(v));
  result := This;
end;

function ADODataSet_supports(This, v: Tvalue): Tvalue; cdecl;
var
  real: TCustomADODataSet;
  i: Integer;
  CursorOptions: TCursorOptions absolute i;
begin
  real := ap_data_get_struct(This);
//  real.Supports(TCursorOptions(dl_ary_to_set(v)));
//  SetOrdProp(real, 'Supports', dl_ary_to_set(v));
  i := dl_ary_to_set(v);
  result := ap_bool(real.Supports(CursorOptions));
end;

function ADODataSet_get_properties(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
   real: TCustomADODataSet;
   args: array of Tvalue;
begin
   if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
   SetLength(args, argc);
   args := argv;
   real := ap_data_get_struct(This);
   result := ap_iProperty(real.Properties[dl_Variant(args[0])], This);
end;

procedure Init_ADODataSet;
begin
  DefineConstSetType(mRDB, TypeInfo(TADOLockType));
  DefineConstSetType(mRDB, TypeInfo(TCommandType));
  DefineConstSetType(mRDB, TypeInfo(TCursorLocation));
  DefineConstSetType(mRDB, TypeInfo(TCursorType));
  DefineConstSetType(mRDB, TypeInfo(TCursorOption));
  cADODataSet := DefinePersistentClass(mRDB, TADODataSet, cDataSet, ap_iADODataSet_v);
  DefineSingletonMethod(cADODataSet, 'new', ADODataSet_new);
  rb_define_method(cADODataSet, 'clone', @ADODataSet_clone, 1);
  rb_define_method(cADODataSet, 'supports', @ADODataSet_supports, 1);
  DefineIndexer(cADODataSet, 'properties', @ADODataSet_get_properties, nil);
end;

end.
