unit uDataSet;

{$I heverdef.inc}

interface

uses
  DB,
{$IFDEF VCL}
  DBTables,
{$ENDIF}
  Rubies;

var
  cDataSet: Tvalue;

function DataSetTmpAlloc(Dataset: TDataSet; owner: Tvalue): Tvalue;
procedure DataSet_setup(This: Tvalue; real: TDataSet);
function DataSet_alloc1(This: Tvalue; real: TDataSet): Tvalue;
procedure Init_DataSet;

implementation

uses
  SysUtils, Classes,
{$IFDEF VCL}
  Graphics,
{$ENDIF}
  uDefUtils, Pythia,
{$IFDEF DELPHI6_UP}
  Variants,
{$ENDIF}
  RDBHandle, uRDB,
{$IFDEF VCL}
  uDatabase, uTable, uQuery, uStoredProc,
{$ENDIF}
  uField, uFieldDef;

{$IFDEF VCL}
function dl_DBDataSet(This: Tvalue): TDBDataSet;
begin
  result := ap_data_get_struct(This);
end;
{$ENDIF}

function dl_DataSet(This: Tvalue): TDataSet;
begin
  result := ap_data_get_struct(This);
end;

function DataSetTmpAlloc(Dataset: TDataSet; owner: Tvalue): Tvalue;
begin
{$IFDEF VCL}
  if DataSet is TTable then
    result := ap_iTable(TTable(DataSet), owner)
  else if DataSet is TQuery then
    result := ap_iQuery(TQuery(DataSet), owner)
  else if DataSet is TStoredProc then
    result := ap_iStoredProc(TStoredProc(DataSet), owner)
  else
    result := Qnil { error };
{$ELSE}
    result := Qnil { error };
{$ENDIF}
end;

procedure DataSet_setup(This: Tvalue; real: TDataSet);
begin
//see: [ap-dev:0625]
  rb_iv_set(This, '@field_defs', ap_iFieldDefs(real.FieldDefs, This));
//rb_iv_set(This, '@index_defs', ap_iIndexDefs(real.IndexDefs, This));
//    AssignPropMethod(real, [Handle]);
end;

function DataSet_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

procedure CompoFree(real: TComponent); cdecl;
begin
  try
    real.tag := 0;
    if csDestroying in real.ComponentState then
      PhiObjectList.Extract(real)
    else
      PhiObjectList.Remove(real);
  except
    on E: Exception do;
  end;
end;

procedure DataSet_free(real: TDataSet); cdecl;
begin
  if real.Active then real.Close;
  CompoFree(real);
end;

// CompoAlloc modified
function DataSet_alloc1(This: Tvalue; real: TDataSet): Tvalue;
begin
  if real = nil then begin result := Qnil; exit; end;
  PhiObjectList.Add(real);
  result := rb_data_object_alloc(This, real, nil, @DataSet_free);
  rb_iv_set(result, '@events', rb_hash_new);
  real.tag := result;
end;

function DataSet_aref(This, p: Tvalue): Tvalue; cdecl;
var
  n: Integer;
  real: TDataSet;
  field: TField;
begin
  real := dl_DataSet(This);
  field := nil;

  case RTYPE(p) of
  T_STRING:
      field := real.FindField(dl_String(p));
  T_FIXNUM:
    begin
      n := FIX2INT(p);
      if (n < 0) or (real.Fields.Count <= n) then
        ap_raise(ap_eIndexError, sOut_of_range);
      field := real.Fields[n];
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
  end;

  if field = nil then
    result := Qnil
  else
    result := ap_iField(field, This);
end;

function DataSet_aset(This, p, v: Tvalue): Tvalue; cdecl;
var
  n: Integer;
  real: TDataSet;
  field: TField;
begin
  real := dl_DataSet(This);
  field := nil;

  case RTYPE(p) of
  T_STRING:
      field := real.FindField(dl_String(p));
  T_FIXNUM:
    begin
      n := FIX2INT(p);
      if (n < 0) or (real.Fields.Count <= n) then
        ap_raise(ap_eIndexError, sOut_of_range);
      field := real.Fields[n];
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
  end;

  if field = nil then
    result := Qnil
  else
  begin
    result := ap_iField(field, This);
    Field_ap_data_assign(field , v);
  end;
end;

function DataSet_get_fields(This: Tvalue): Tvalue; cdecl;
begin
  result := TmpAlloc(cFields, dl_DataSet(This).Fields);
end;

function DataSet_get_state(This: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(Ord(dl_DataSet(This).State));
end;

function DataSet_close(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Close;
  result := This;
end;

function DataSet_open(This: Tvalue): Tvalue; cdecl;
begin
//rb_p(ap_String('DataSet_open'));
  dl_DataSet(This).Open;
  result := This;
end;

function DataSet_edit(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Edit;
  result := This;
end;

function DataSet_post(This: Tvalue): Tvalue; cdecl;
begin
  try
    dl_DataSet(This).Post;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function DataSet_append(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Append;
  result := This;
end;

function DataSet_insert(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Insert;
  result := This;
end;

function DataSet_delete(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Delete;
  result := This;
end;

function DataSet_first(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).First;
  result := This;
end;

function DataSet_last(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Last;
  result := This;
end;

function DataSet_next(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Next;
  result := This;
end;

function DataSet_prior(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Prior;
  result := This;
end;

function DataSet_move_by(This, v: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(dl_DataSet(This).MoveBy(FIX2INT(v)));
end;

function DataSet_locate(This, fields, values, options: Tvalue): Tvalue; cdecl;
var
  v: Tvalue;
  i: Integer;
  n: Integer;
  len: Integer;
  ptr: Pvalue;
  A: Variant;
  field: TField;
  ary: Tvalue;
  Opts: TLocateOptions;
  real: TDataSet;
begin
  real := dl_DataSet(This);

  v := values;
  case RTYPE(v) of
  T_ARRAY:
    begin
      len := ap_ary_len(v);
      ptr := ap_ary_ptr(v);
      A := VarArrayCreate([0, len-1], varVariant);
      for i := 0 to len-1 do
      begin
        v := ptr^;
        case RTYPE(v) of
        T_STRING: A[i] := string(dl_String(v));
        T_FIXNUM: A[i] := FIX2INT(v);
        T_BIGNUM: A[i] := NUM2INT(v);
        T_FLOAT : A[i] := NUM2DBL(v);
        T_TRUE  : A[i] := True;
        T_FALSE : A[i] := False;
        T_DATA  :
          begin
            ap_data_get_object(v, TField, field);
            A[i] := field.AsString;
          end;
        else
          ap_raise(ap_eArgError, sWrong_arg_type);
        end;
        Inc(ptr);
      end;
    end;
  T_STRING: A := string(dl_String(v));
  T_FIXNUM: A := FIX2INT(v);
  T_BIGNUM: A := NUM2INT(v);
  T_FLOAT : A := NUM2DBL(v);
  T_TRUE  : A := True;
  T_FALSE : A := False;
  T_DATA  :
    begin
      ap_data_get_object(v, TField, field);
      A := field.AsString;
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
  end;

  ary := options;
  Check_Type(ary, T_ARRAY);
  len := ap_ary_len(ary);
  ptr := ap_ary_ptr(ary);
  Opts := [];
  while len > 0 do
  begin
    n := FIX2INT(ptr^);
    try
      Include(Opts, TLocateOption(n));
    except
      ap_raise(ap_eIndexError, sOut_of_range);
    end;
    Dec(len);
    Inc(ptr);
  end;

  result := Qnil;
  try
    result := ap_bool(real.Locate(dl_String(fields), A, Opts));
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
end;

function DataSet_get_bof(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(dl_DataSet(This).Bof);
end;

function DataSet_get_eof(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(dl_DataSet(This).Eof);
end;

{$IFDEF VCL}
function DataSet_get_updates_pending(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(dl_DBDataSet(This).UpdatesPending);
end;

function DataSet_apply_updates(This: Tvalue): Tvalue; cdecl;
begin
  result := This;
  dl_DBDataSet(This).ApplyUpdates;
end;

function DataSet_commit_updates(This: Tvalue): Tvalue; cdecl;
begin
  result := This;
  dl_DBDataSet(This).CommitUpdates;
end;

function DataSet_update_status(This: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(ord(dl_DBDataSet(This).UpdateStatus));
end;
{$ENDIF}

function DataSet_bookmark(This: Tvalue): Tvalue; cdecl;
var
  real: TDataSet;
  Bookmark: TBookmark;
begin
  if rb_block_given_p = 0 then ap_raise(ap_eDatabaseError, 'need block');
  real := dl_DataSet(This);
  Bookmark := real.GetBookmark;
  try
    result := rb_ensure(@rb_yield, This, @retnil, This);
  finally
    real.GotoBookmark(Bookmark);
    real.FreeBookmark(Bookmark);
  end;
end;

function DataSet_disable_controls(This: Tvalue): Tvalue; cdecl;
var
  real: TDataSet;
begin
  if rb_block_given_p = 0 then ap_raise(ap_eDatabaseError, 'need block');
  real := dl_DataSet(This);
  real.DisableControls;
  try
    result := rb_ensure(@rb_yield, This, @retnil, This);
  finally
    real.EnableControls;
  end;
end;

function DataSet_refresh(This: Tvalue): Tvalue; cdecl;
begin
  result := This;
  dl_DataSet(This).Refresh;
end;

function DataSet_cancel(This: Tvalue): Tvalue; cdecl;
begin
  result := This;
  dl_DataSet(This).Cancel;
end;

{$IFDEF VCL}
function DataSet_get_database(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_iDatabase(dl_DBDataSet(This).Database, This);
end;
{$ENDIF}

procedure Init_DataSet;
begin
  DefineConstSetType(mRDB, TypeInfo(TDataSetState));
  DefineConstSetType(mRDB, TypeInfo(TDataAction));
  DefineConstSetType(mRDB, TypeInfo(TLocateOption));

  cDataSet := DefinePersistentClass(mRDB, TDataSet, ap_cComponent, nil);
  rb_define_method(cDataSet, 'event_handle', @DataSet_event_handle, 1);
  rb_undef_method(CLASS_OF(cDataSet), 'new');
  DefineAttrGet(cDataSet, 'fields', DataSet_get_fields);
  DefineAttrGet(cDataSet, 'state', DataSet_get_state);
  rb_define_method(cDataSet, 'open', @DataSet_open, 0);
  rb_define_method(cDataSet, 'close', @DataSet_close, 0);
  rb_define_method(cDataSet, 'edit', @DataSet_edit, 0);
  rb_define_method(cDataSet, 'post', @DataSet_post, 0);
  rb_define_method(cDataSet, 'append', @DataSet_append, 0);
  rb_define_method(cDataSet, 'insert', @DataSet_insert, 0);
  rb_define_method(cDataSet, 'delete', @DataSet_delete, 0);

  // vcl: FieldByName, FindField
  rb_define_method(cDataSet, '[]', @DataSet_aref, 1);
  rb_define_method(cDataSet, '[]=', @DataSet_aset, 2);

  rb_define_method(cDataSet, 'first', @DataSet_first, 0);
  rb_define_method(cDataSet, 'last', @DataSet_last, 0);
  rb_define_method(cDataSet, 'next', @DataSet_next, 0);
  rb_define_method(cDataSet, 'prior', @DataSet_prior, 0);
  rb_define_method(cDataSet, 'move_by', @DataSet_move_by, 1);
  rb_define_method(cDataSet, 'locate', @DataSet_locate, 3);
  DefineAttrGet(cDataSet, 'bof?', DataSet_get_bof);
  DefineAttrGet(cDataSet, 'eof?', DataSet_get_eof);

{$IFDEF VCL}
  DefineAttrGet(cDataSet, 'updates_pending', DataSet_get_updates_pending);
  rb_define_method(cDataSet, 'apply_updates', @DataSet_apply_updates, 0);
  rb_define_method(cDataSet, 'update_status', @DataSet_update_status, 0);
  rb_define_method(cDataSet, 'commit_updates', @DataSet_commit_updates, 0);
{$ENDIF}

  rb_define_method(cDataSet, 'bookmark', @DataSet_bookmark, 0);
  rb_define_method(cDataSet, 'disable_controls', @DataSet_disable_controls, 0);
  rb_define_method(cDataSet, 'refresh', @DataSet_refresh, 0);
  rb_define_method(cDataSet, 'cancel', @DataSet_cancel, 0);
{$IFDEF VCL}
  DefineAttrGet(cDataSet, 'database', DataSet_get_database);
{$ENDIF}
end;

end.
