unit uSQLConnection;

interface

uses Rubies, SqlExpr, DBXpress;

var
  cSQLConnection: Tvalue;

function ap_cSQLConnection: Tvalue;
function ap_iSQLConnection(real: TSQLConnection; owner: Tvalue): Tvalue;
procedure Init_SQLConnection;

implementation

uses SysUtils, Classes, DB, uDefUtils, Pythia, uRDB, uDataSet;

var
  TD: TTransactionDesc;

function ap_cSQLConnection: Tvalue;
begin
  result := cSQLConnection;
end;

procedure CompoFree(real: TComponent); cdecl;
begin
  try
    real.tag := 0;
    if csDestroying in real.ComponentState then
      PhiObjectList.Extract(real)
    else
      PhiObjectList.Remove(real);
  except
    on E: Exception do;
  end;
end;

procedure SQLConnection_free(real: TSQLConnection); cdecl;
begin
  if real.Connected then real.Close;
  CompoFree(real);
end;

// CompoAlloc modified
function SQLConnection_alloc1(This: Tvalue; real: TSQLConnection): Tvalue;
begin
  if real = nil then begin result := Qnil; exit; end;
  PhiObjectList.Add(real);
  result := rb_data_object_alloc(This, real, nil, @SQLConnection_free);
  rb_iv_set(result, '@events', rb_hash_new);
  real.tag := result;
end;

function SQLConnection_alloc(This: Tvalue; real: TSQLConnection): Tvalue;
begin
  result := ChildAlloc(This, real);
end;

function ap_iSQLConnection(real: TSQLConnection; owner: Tvalue): Tvalue;
begin
  result := SQLConnection_alloc(cSQLConnection, real);
  ap_owner(result, owner);
end;

function ap_iSQLConnection_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iSQLConnection(TSQLConnection(obj), owner)
end;

function SQLConnection_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
  args: array of Tvalue;
begin
  real := TSQLConnection.Create(nil);
  if argc > 0 then
  begin
    SetLength(args, argc);
    args := argv;
    try
      real.ConnectionName := dl_String(args[0]);
      real.LoginPrompt := False;
      real.LoadParamsOnConnect := True;
    except
      on E: Exception do
        ap_raise(ap_eDatabaseError, E.message);
    end;
  end;
  result := SQLConnection_alloc1(This, real);
  rb_obj_call_init(result, argc, argv);
end;

function SQLConnection_execute(This, sql, v: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
  Params: TParams;
begin
  result := Qnil;
  real := ap_data_get_struct(This);
  try
    ap_data_get_object(v, TParams, Params);
    result := INT2FIX(real.Execute(dl_String(sql), Params));
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
end;

function SQLConnection_execute_direct(This, sql: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
begin
  result := Qnil;
  real := ap_data_get_struct(This);
  try
    result := INT2FIX(real.ExecuteDirect(dl_String(sql)));
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
end;

function SQLConnection_open(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
begin
  real := ap_data_get_struct(This);
  real.Open;
  result := This;
end;

function SQLConnection_close(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
begin
  real := ap_data_get_struct(This);
  real.Close;
  result := This;
end;

function SQLConnection_close_datasets(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
begin
  real := ap_data_get_struct(This);
  try
    real.CloseDatasets;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function SQLConnection_commit(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
begin
  real := ap_data_get_struct(This);
  try
    real.Commit(TD);
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function SQLConnection_rollback(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
begin
  real := ap_data_get_struct(This);
  try
    real.Rollback(TD);
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function SQLConnection_start_transaction(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
begin
  real := ap_data_get_struct(This);
  try
    real.StartTransaction(TD);
  except on E: Exception do
    ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function SQLConnection_load_params_from_ini_file(This, fname: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
begin
  real := ap_data_get_struct(This);
  try
    real.LoadParamsFromIniFile(dl_String(fname));
  except on E: Exception do
    ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

type Tvalue_array = array of Tvalue;

function SQLConnection_get_table_names(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
  SystemTable : boolean;
begin
  result := ap_StringList_new;
  real := ap_data_get_struct(This);
  SystemTable := False; // default
  if argc > 1 then ap_raise(ap_eArgError, sWrong_num_of_args);
  if argc > 0 then SystemTable := dl_Boolean(argv[0]);
  real.GetTableNames( dl_Strings(result), SystemTable );
end;

function SQLConnection_get_params(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
begin
  real := ap_data_get_struct(This);
  result := ap_iStrings(real.Params, This);
end;

function SQLConnection_get_data_sets(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
  i:integer;
begin
  result := rb_ary_new;
  real := ap_data_get_struct(This);
  try
    for i := 0 to real.DataSetCount-1 do
    begin
      rb_ary_push(result, DataSetTmpAlloc(real.DataSets[i], This));
    end;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
end;

procedure Init_SQLConnection;
begin
  TD.TransactionID := 1;
  TD.IsolationLevel := xilREADCOMMITTED;

  cSQLConnection := DefinePersistentClass(mRDB, TSQLConnection, ap_cComponent, ap_iSQLConnection_v);
  DefineSingletonMethod(cSQLConnection, 'new', SQLConnection_new);
  rb_define_method(cSQLConnection, 'execute', @SQLConnection_execute, 2);
  rb_define_method(cSQLConnection, 'execute_direct', @SQLConnection_execute_direct, 1);
//  rb_define_method(cSQLConnection, 'open', @SQLConnection_open, 0);
  rb_define_method(cSQLConnection, 'close', @SQLConnection_close, 0);
  rb_define_method(cSQLConnection, 'close_datasets', @SQLConnection_close_datasets, 0);
  rb_define_method(cSQLConnection, 'commit', @SQLConnection_commit, 0);
  rb_define_method(cSQLConnection, 'rollback', @SQLConnection_rollback, 0);
  rb_define_method(cSQLConnection, 'start_transaction', @SQLConnection_start_transaction, 0);
  rb_define_method(cSQLConnection, 'load_params_from_ini_file', @SQLConnection_load_params_from_ini_file, 1);
  rb_define_method(cSQLConnection, 'table_names', @SQLConnection_get_table_names, -1);

  DefineAttrGet(cSQLConnection, 'params', SQLConnection_get_params);
  DefineAttrGet(cSQLConnection, 'data_sets', SQLConnection_get_data_sets);
end;

end.
