unit uSQLDataSet;

interface

uses Rubies;

var
  cSQLDataSet: Tvalue;

procedure Init_SQLDataSet;

implementation

uses SysUtils, SqlExpr, uDefUtils, Pythia, uDataSet, uRDB, uFieldDef, uIndexDef;

procedure SQLDataSet_setup(obj: Tvalue; real: TSQLDataSet);
begin
  DataSet_setup(obj, real);
  rb_iv_set(obj, '@index_defs', ap_iIndexDefs(real.IndexDefs, obj));
end;

function SQLDataSet_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSQLDataSet;
begin
  real := TSQLDataSet.Create(nil);
  result := DataSet_alloc1(This, real);
  SQLDataSet_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_SQLDataSet;
begin
  cSQLDataSet := DefinePersistentClass(mRDB, TSQLDataSet, cDataSet, nil);
  DefineSingletonMethod(cSQLDataSet, 'new', SQLDataSet_new);
end;

end.
