unit uSQLStoredProc;

interface

uses Rubies;

var
  cSQLStoredProc: Tvalue;

procedure Init_SQLStoredProc;

implementation

uses SqlExpr, uDefUtils, Pythia, uRDB, uDataSet, uParam;

procedure SQLStoredProc_setup(obj: Tvalue; real: TSQLStoredProc);
begin
  DataSet_setup(obj, real);
end;

function SQLStoredProc_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSQLStoredProc;
begin
  real := TSQLStoredProc.Create(nil);
  result := DataSet_alloc1(This, real);
  SQLStoredProc_setup(result, real);

  rb_obj_call_init(result, argc, argv);
end;

function SQLStoredProc_exec_proc(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLStoredProc;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.ExecProc);
end;

function SQLStoredProc_get_params(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLStoredProc;
begin
  real := ap_data_get_struct(This);
  result := ap_iParams(real.Params, This);
end;

procedure Init_SQLStoredProc;
begin
  cSQLStoredProc := DefinePersistentClass(mRDB, TSQLStoredProc, ap_cPersistent, nil);
  DefineSingletonMethod(cSQLStoredProc, 'new', SQLStoredProc_new);
  rb_define_method(cSQLStoredProc, 'exec_proc', @SQLStoredProc_exec_proc, 0);
  DefineAttrGet(cSQLStoredProc, 'params', SQLStoredProc_get_params);
end;

end.
