unit uSQLTable;

interface

uses Rubies;

var
  cSQLTable: Tvalue;

procedure Init_SQLTable;

implementation

uses SysUtils, SqlExpr, uDefUtils, Pythia, uDataSet, uRDB, uFieldDef, uIndexDef;

procedure SQLTable_setup(obj: Tvalue; real: TSQLTable);
begin
  DataSet_setup(obj, real);
  rb_iv_set(obj, '@index_defs', ap_iIndexDefs(real.IndexDefs, obj));
end;

function SQLTable_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSQLTable;
begin
  real := TSQLTable.Create(nil);
  result := DataSet_alloc1(This, real);
  SQLTable_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_SQLTable;
begin
  cSQLTable := DefinePersistentClass(mRDB, TSQLTable, cDataSet, nil);
  DefineSingletonMethod(cSQLTable, 'new', SQLTable_new);
end;

end.
