require 'phi'
require 'strcolgrid'

include Phi

form1 = Form.new

btn = Button.new form1
btn = btn.align = Phi::AL_TOP

scgrid1 = StrColGrid.new form1
scgrid1.align = Phi::AL_CLIENT

scgrid1.fixed_layout = Phi::TL_CENTER
scgrid1.focus_cell_color = Phi::CL_LT_GRAY
scgrid1.focus_cell_font_color = Phi::CL_BLUE

scgrid1.focus_cell_font_color_enabled = true
scgrid1.layout = Phi::TL_CENTER
scgrid1.options = [Phi::GO_FIXED_VERT_LINE, Phi::GO_FIXED_HORZ_LINE, Phi::GO_VERT_LINE, Phi::GO_HORZ_LINE, Phi::GO_COL_SIZING, Phi::GO_TABS, Phi::GO_DRAW_FOCUS_SELECTED, Phi::GO_THUMB_TRACKING]

param = scgrid1.cell_params.add

param.alignment = TA_CENTER
param.row = 1
param.col = 1

begin
0.upto(4) {|i|
  0.upto(4) {|j|
    scgrid1.cells[i, j] = "(#{i}, #{j})"
  }
}
end


def scgrid1.on_cell_changed(oldcol, oldrow, newcol, newrow)
  p 'oldrow = ' + oldrow.to_s
  p 'newrow = ' + newrow.to_s 
end


p 'caption = ' + param.caption
p 'caption_type = ' + param.caption_type.to_s
p 'cell_color = ' + param.cell_color.to_s
p 'cell_color_enabled = ' + param.cell_color_enabled.to_s
p 'col = ' + param.col.to_s
p 'col_max = ' + param.col_max.to_s
p 'brush_enabled = ' + param.brush_enabled.to_s
p 'font_name = ' + param.font_name.to_s
p 'font_color = ' + param.font_color.to_s
p 'font_color_enabled = ' + param.font_color_enabled.to_s
p 'font_width = ' + param.font_width.to_s
p 'ime_mode = ' + param.ime_mode.to_s
p 'ime_mode_enabled = ' + param.ime_mode_enabled.to_s
p 'layout = ' + param.layout.to_s
p 'name = ' + param.name.to_s
p 'options = ' + param.options.to_s
p 'options_enabled = ' + param.options_enabled.to_s
p 'range_enabled = ' + param.range_enabled.to_s
p 'row = ' + param.row.to_s
p 'row_max = ' + param.row_max.to_s

form1.show

Phi.mainloop

