unit uApplication;

interface

uses
  Rubies, Pythia,
  WebBroker;

var
  cWebApplication: Tvalue;
  vWebApplication: Tvalue;

function ap_cWebApplication: Tvalue;
function ap_vWebApplication: Tvalue;
function Regist_WebApplication(real: TWebApplication; owner: Tvalue): Tvalue;
procedure Init_WebApplication;

implementation

uses
{$IFDEF MSWINDOWS}
  Windows,
{$ENDIF}
  Classes, SysUtils,
{$IFDEF VCL}
  Graphics,
{$ELSE}
  QGraphics,
{$ENDIF}
  uDefUtils, uWeb;

function ap_cWebApplication: Tvalue;
begin
  result := cWebApplication;
end;

function ap_vWebApplication: Tvalue;
begin
  result := vWebApplication;
end;

function WebApplication_set_title(This, v: Tvalue): Tvalue; cdecl;
var
  real: TWebApplication;
begin
  real := ap_data_get_struct(This);
  real.Title := dl_String(v);
  result := v;
  rb_iv_set(This, '@title', v);
end;

function WebApplication_get_title(This: Tvalue): Tvalue; cdecl;
begin
  result := rb_iv_get(This, '@title');
end;

function WebApplication_instance(This: Tvalue): Tvalue; cdecl;
begin
  result := vWebApplication;
end;

function Regist_WebApplication(real: TWebApplication; owner: Tvalue): Tvalue;
begin
//  if real.handle = 0 then real.CreateHandle;
  result := ChildAlloc(cWebApplication, real);
  vWebApplication := result;
  rb_define_const(mWeb, 'APPLICATION', result);
  rb_iv_set(result, '@title', rb_str_new2(PChar(real.Title)));
end;

procedure Init_WebApplication;
begin
  cWebApplication := rb_define_class_under(mWeb, 'Application', ap_cObject);
  DefineProp(cWebApplication, TWebApplication);

  rb_undef_method(CLASS_OF(cWebApplication), 'new');
  rb_define_singleton_method(cWebApplication, 'instance', @WebApplication_instance, 0);

  DefineAttrSet(cWebApplication, 'title', WebApplication_set_title);
  DefineAttrGet(cWebApplication, 'title', WebApplication_get_title);
end;

exports
  Regist_WebApplication;

end.
