def parse(line)
  line.chomp!

  case line
  when /^procedure\s+/, /^function\s+/
    $finterface.print line, " cdecl;"
  else
    $finterface.print line
  end
  $finterface.print "\n"

  line.gsub!( /\(.*?\)/, '' )

  case line
  when /^procedure\s+(\w+)/
p   apfunc = $1
    $fimplement.print line, $extern
  when /^function\s+(\w+)/
p   apfunc = $1
    $fimplement.print line[0...line.rindex(':')], ';', $extern
  else
    $fimplement.print line
  end
  $fimplement.print "\n"
end

$extern = " cdecl; external RubyDLL;"

$finterface = open('funcint.pas', 'w')
$fimplement = open('funcimp.pas', 'w')

Dir.glob('func/rb_*.pas').each{|entry|
  print "found #{entry}\n"
  open(entry){|f|
    while line = f.gets
      parse line
    end
  }
}

$fimplement.close
$finterface.close

