unit uBitmap;

interface

uses
{$IFDEF VCL}
  Graphics,
{$ELSE}
  QGraphics,
{$ENDIF}
  Rubies;

var
  cBitmap: Tvalue;

function ap_cBitmap: Tvalue;
function ap_iBitmap(real: TBitmap; owner: Tvalue): Tvalue;
procedure Init_Bitmap;

implementation

uses
  Classes, SysUtils,
  uDefUtils, uIntern, uAlloc, uProp, uPhi, uCanvas;

function ap_cBitmap: Tvalue;
begin
  result := cBitmap;
end;

procedure Bitmap_setup(obj: Tvalue; real: TBitmap);
begin
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
end;

function Bitmap_alloc(klass: Tvalue; real: TBitmap): Tvalue;
begin
  result := TmpAlloc(klass, real);
  Bitmap_setup(result, real);
end;

function ap_iBitmap(real: TBitmap; owner: Tvalue): Tvalue;
begin
  result := Bitmap_alloc(cBitmap, real);
  ap_owner(result, owner);
end;

function Bitmap_new(This: Tvalue): Tvalue; cdecl;
var
  real: TBitmap;
begin
  real := TBitmap.Create;
  result := ObjAlloc(This, real);
  Bitmap_setup(result, real);
  ap_obj_call_init(result, 0, nil);
end;

function Bitmap_load(This, v: Tvalue): Tvalue; cdecl;
var
  real: TBitmap;
  stream: TStream;
begin
  real := ap_data_get_struct(This);
  case RTYPE(v) of
  T_STRING:
    try
      real.LoadFromFile(dl_String(v));
    except
      on E: EFOpenError do
        ap_raise(ap_eIOError, E.message);
      on E: EInvalidGraphic do
        ap_raise(ap_eStandardError, E.message);
    end;
  T_DATA:
    try
      ap_data_get_object(v, TStream, stream);
      real.LoadFromStream(stream);
    except
      on E: EReadError do;
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
  end;
  result := This;
end;

function Bitmap_save(This, v: Tvalue): Tvalue; cdecl;
var
  real: TBitmap;
  stream: TStream;
begin
  real := ap_data_get_struct(This);
  case RTYPE(v) of
  T_STRING:
    try
      real.SaveToFile(dl_String(v));
    except
      on E: EFCreateError do
        ap_raise(ap_eIOError, E.message);
    end;
  T_DATA:
    try
      ap_data_get_object(v, TStream, stream);
      real.SaveToStream(stream);
    except
      on E: EWriteError do;
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
  end;
  result := v;
end;

function Bitmap_assign(This, v: Tvalue): Tvalue; cdecl;
var
  real: TBitmap;
  source: TPersistent;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TPersistent, source);
  try
    real.Assign(source);
  except
    on E: EConvertError do
      ap_raise(ap_eStandardError, E.message);
  end;
  result := v;
end;

function Bitmap_get_width(This: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(TBitmap(ap_data_get_struct(This)).width);
end;

function Bitmap_set_width(This, v: Tvalue): Tvalue; cdecl;
begin
  TBitmap(ap_data_get_struct(This)).width := FIX2INT(v);
  result := v;
end;

function Bitmap_get_height(This: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(TBitmap(ap_data_get_struct(This)).height);
end;

function Bitmap_set_height(This, v: Tvalue): Tvalue; cdecl;
begin
  TBitmap(ap_data_get_struct(This)).height := FIX2INT(v);
  result := v;
end;

function Bitmap_get_monochrome(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(TBitmap(ap_data_get_struct(This)).monochrome);
end;

function Bitmap_set_monochrome(This, v: Tvalue): Tvalue; cdecl;
begin
  TBitmap(ap_data_get_struct(This)).monochrome := RTEST(v);
  result := v;
end;

procedure Init_Bitmap;
begin
  cBitmap := rb_define_class_under(mPhi, 'Bitmap', ap_cObject);
  OutputProp(cBitmap, TBitmap);

  rb_define_singleton_method(cBitmap, 'new', @Bitmap_new, 0);
  rb_define_method(cBitmap, 'load', @Bitmap_load, 1);
  rb_define_method(cBitmap, 'save', @Bitmap_save, 1);
  rb_define_method(cBitmap, 'assign', @Bitmap_assign, 1);
  rb_define_attr(cBitmap, 'canvas', 1, 0);
  DefineAttrSet(cBitmap, 'width', Bitmap_set_width);
  DefineAttrGet(cBitmap, 'width', Bitmap_get_width);
  DefineAttrSet(cBitmap, 'height', Bitmap_set_height);
  DefineAttrGet(cBitmap, 'height', Bitmap_get_height);
  DefineAttrSet(cBitmap, 'monochrome', Bitmap_set_monochrome);
  DefineAttrGet(cBitmap, 'monochrome', Bitmap_get_monochrome);
  rb_define_alias(cBitmap, 'monochrome?', 'monochrome');
end;

end.
