unit uCheckBox;

interface

uses
{$IFDEF VCL}
  StdCtrls,
{$ELSE}
  QStdCtrls,
{$ENDIF}
  Rubies;

var
  cCheckBox: Tvalue;

function ap_cCheckBox: Tvalue;
function ap_iCheckBox(real: TCheckBox; owner: Tvalue): Tvalue;
procedure Init_CheckBox;

implementation

uses
  Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl, uButton;

function ap_cCheckBox: Tvalue;
begin
  result := cCheckBox;
end;

procedure CheckBox_setup(obj: Tvalue; real: TCheckBox);
begin
//    AssignPropMethod(real, [Handle]);
end;

function CheckBox_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function CheckBox_alloc(This: Tvalue; real: TCheckBox): Tvalue;
begin
  result := ChildAlloc(This, real);
  CheckBox_setup(result, real);
end;

function ap_iCheckBox(real: TCheckBox; owner: Tvalue): Tvalue;
begin
  result := CheckBox_alloc(cCheckBox, real);
  ap_owner(result, owner);
end;

function ap_iCheckBox_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iCheckBox(TCheckBox(AControl), owner)
end;

function CheckBox_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TCheckBox;
begin
  real := TCheckBox.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  CheckBox_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function CheckBox_set_caption(This, v: Tvalue): Tvalue; cdecl;
var
  real: TCheckBox;
begin
  real := ap_data_get_struct(This);
  real.caption := dl_String(v);
  result := v;
end;

procedure Init_CheckBox;
begin
//  OutputConstSetType(mPhi, TypeInfo(TLeftRight));
  OutputConstSetType(mPhi, TypeInfo(TCheckBoxState));

  cCheckBox := OutputPersistentClass(mPhi, TCheckBox, cButton, ap_iCheckBox_v);
  rb_define_method(cCheckBox, 'event_handle', @CheckBox_event_handle, 1);
  DefineSingletonMethod(cCheckBox, 'new', CheckBox_new);
  DefineAttrSet(cCheckBox, 'caption', CheckBox_set_caption);
end;

end.
