unit uControl;

interface

uses
{$IFDEF VCL}
  Controls,
{$ELSE}
  QControls,
{$ENDIF}
  Rubies;

var
  cControl, cWinControl: Tvalue;

procedure ClearEvents(AControl: TControl);
function ap_cControl: Tvalue;
function ap_cWinControl: Tvalue;
procedure Init_control;

implementation

uses
{$IFDEF LINUX}
  Types,
{$ENDIF}
{$IFDEF MSWINDOWS}
  Windows,
{$ENDIF}
  TypInfo,
  uDefUtils, uIntern, uProp, uPhi, uConv, uPoint, uRect, uPersistent, uComponent;

type
  TMyWinControl = class(TWinControl);

procedure ClearEvents(AControl: TControl);
var
  i: Integer;
  real: TWinControl;
  obj, events: Tvalue;
begin
  if not (AControl is TWinControl) then Exit;
  real := TWinControl(AControl);
  for i := 0 to real.ControlCount-1 do
    ClearEvents(real.Controls[i]);
  obj := real.tag;
  if obj = 0 then Exit; // undefined
  events := rb_iv_get(obj, '@events');
  if events <> Qnil then
    rb_funcall2(events, id_clear, 0, nil);
end;

function ap_cControl: Tvalue;
begin
  result := cControl;
end;

function ap_cWinControl: Tvalue;
begin
  result := cWinControl;
end;

function Control_show(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
asm
  FInit;
end;
  real.Show;
  result := This;
end;

function Control_hide(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.Hide;
  result := This;
end;

function Control_bring_to_front(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.BringToFront;
  result := This;
end;

function Control_send_to_back(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.SendToBack;
  result := This;
end;

function Control_screen_to_client(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  point: TPoint;
begin
  real := ap_data_get_struct(This);
  point := real.ScreenToClient(TPoint(ap_data_get_struct(v)^));
  result := ap_iPoint(point, Qnil);
end;

function Control_set_bounds(This, left, top, width, height: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.SetBounds(FIX2INT(left), FIX2INT(top), FIX2INT(width), FIX2INT(height));
  result := This;
end;

function Control_client_to_screen(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  point: TPoint;
begin
  real := ap_data_get_struct(This);
  point := real.ClientToScreen(TPoint(ap_data_get_struct(v)^));
  result := ap_iPoint(point, Qnil);
end;

function Control_set_rect(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.BoundsRect := PRect(ap_data_get_struct(v))^;
  result := v;
end;

function Control_get_rect(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  result := ap_iRect(real.BoundsRect, This);
end;

function Control_set_align(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.Align := TAlign(FIX2INT(v));
  result := v;
end;

function Control_get_align(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(Ord(real.Align));
end;

function Control_set_parent(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  control: TWinControl;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TWinControl, control);
  real.parent := TWinControl(control);
  rb_iv_set(This, '@parent', v);
  result := v;
end;

type
  Tvalue_array = array of Tvalue;

function Control_begin_drag(argc: integer; args: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  Immediate: Boolean;
  Threshold: Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  if argc > 1 then
    Threshold := FIX2INT(args[1])
  else
    Threshold := -1
  ;
  real := ap_data_get_struct(This);
  Immediate := RTEST(args[0]);
  real.BeginDrag(Immediate, Threshold);
  result := This;
end;

{$IFDEF VCL}
function Control_perform(This, msg, wparam, lparam: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.Perform(
    dl_Integer(msg),
    dl_Integer(wparam),
    dl_Integer(lparam)));
end;
{$ENDIF}

function Control_focused_p(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.focused);
end;

function Control_set_focus(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.SetFocus;
  result := This;
end;

function Control_scale_by(This, m, d: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.ScaleBy(FIX2INT(m), FIX2INT(d));
  result := This;
end;

function Control_invalidate(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.invalidate;
  result := This;
end;

function Control_update(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.update;
  result := This;
end;

function Control_repaint(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.repaint;
  result := This;
end;

function Control_refresh(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.refresh;
  result := This;
end;

function Control_get_handle(This: Tvalue): Tvalue; cdecl;
{$IFDEF VCL}
var
  real: TWinControl;
{$ENDIF}
begin
{$IFDEF VCL}
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Handle);
{$ELSE}
  result := Qnil;
{$ENDIF}
end;

function Control_set_control_state(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  SetOrdProp(real, 'ControlState', dl_ary_to_set(v));
  result := v;
end;

function Control_get_control_state(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  state: TControlState;
begin
  real := ap_data_get_struct(This);
  state := real.ControlState;
  result := ap_set_to_ary(state);
end;

function Control_set_control_style(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  SetOrdProp(real, 'ControlStyle', dl_ary_to_set(v));
  result := v;
end;

function Control_get_control_style(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  style: TControlStyle;
begin
  real := ap_data_get_struct(This);
  style := real.ControlStyle;
  result := ap_set_to_ary(style);
end;

function Control_get_controls(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
  i: Integer;
  args: array of Tvalue;
  obj, control_class, kind_p, push_p: Tvalue;
begin
  SetLength(args, argc);
  args := argv;

  if argc > 0 then
    control_class := args[0]
  else
    control_class := Qnil;

  if argc > 1 then
    kind_p := args[1]
  else
    kind_p := Qnil;

  real := ap_data_get_struct(This);

  if rb_block_given_p <> 0 then
    result := Qnil
  else
    result := rb_ary_new;

  for i := 0 to real.ControlCount-1 do
  begin
    obj := real.Controls[i].tag;
    if obj = 0 then Continue;
    if control_class = Qnil then
      push_p := Qtrue
    else
      if RTEST(kind_p) then
        push_p := rb_obj_is_kind_of(obj, control_class)
      else
        push_p := rb_obj_is_instance_of(obj, control_class);

    if RTEST(push_p) then
      if rb_block_given_p <> 0 then
        rb_yield(obj)
      else
        rb_ary_push(result, obj);

  end;
end;

function Control_get_control_count(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ControlCount);
end;

function Control_stop_align(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  try
    real.DisableAlign;
    result := rb_yield(Qnil);
  finally
    real.EnableAlign;
  end;
end;

function Control_handle_needed(This: TValue): TValue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.HandleNeeded;
  Result := This;
end;

function Control_control_at(This, v: TValue): TValue; cdecl;
var
  real: TWinControl;
  AControl: TControl;
begin
  real := ap_data_get_struct(This);
  AControl := real.ControlAtPos(TPoint(ap_data_get_struct(v)^), True, True);
  if AControl = nil then
    Result := Qnil
  else
    Result := AControl.tag;
end;

function Control_select_first(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.SelectFirst;
  Result := This;
end;

function Control_select_next(This, cur, forward, tab_stop: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  CurControl: TWinControl;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(cur, TWinControl, CurControl);
  real.SelectNext(CurControl, RTEST(forward), RTEST(tab_stop));
  Result := This;
end;

function Control_showing_p(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.Showing);
end;

{$IFDEF VCL}
function Control_set_double_buffered(This, v: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.DoubleBuffered := RTEST(v);
  result := This;
end;

function Control_get_double_buffered(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.DoubleBuffered);
end;
{$ENDIF}

function Control_client_rect(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_iRect(real.ClientRect, This);
end;

function Control_adjusted_client_rect(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  rect:TRect;
begin
  real := ap_data_get_struct(This);
  rect := real.ClientRect;
  real.AdjustClientRect(rect);
  result := ap_iRect(rect, This);
end;

procedure Init_Control;
begin
//  OutputConstSetType(mPhi, TypeInfo(TControlState));
//  OutputConstSetType(mPhi, TypeInfo(TControlStyle));

  cControl := OutputPersistentClass(mPhi, TControl, cComponent, nil);
  { methods }
  rb_define_method(cControl, 'show', @Control_show, 0);
  rb_define_method(cControl, 'hide', @Control_hide, 0);
  rb_define_method(cControl, 'bring_to_front', @Control_bring_to_front, 0);
  rb_define_method(cControl, 'send_to_back', @Control_send_to_back, 0);
  rb_define_method(cControl, 'screen_to_client', @Control_screen_to_client, 1);
  rb_define_method(cControl, 'client_to_screen', @Control_client_to_screen, 1);
  rb_define_method(cControl, 'set_bounds', @Control_set_bounds, 4);
  rb_define_method(cControl, 'begin_drag', @Control_begin_drag, -1);
{$IFDEF VCL}
  rb_define_method(cControl, 'perform', @Control_perform, 3);
{$ENDIF}

  { properties }
  DefineAttrSet(cControl, 'rect', Control_set_rect);
  DefineAttrGet(cControl, 'rect', Control_get_rect);
  DefineAttrSet(cControl, 'align', Control_set_align);
  DefineAttrGet(cControl, 'align', Control_get_align);
  DefineAttrSet(cControl, 'parent', Control_set_parent);
  DefineAttrGet(cControl, 'handle', Control_get_handle);
  DefineAttrSet(cControl, 'control_state', Control_set_control_state);
  DefineAttrGet(cControl, 'control_state', Control_get_control_state);
  DefineAttrSet(cControl, 'control_style', Control_set_control_style);
  DefineAttrGet(cControl, 'control_style', Control_get_control_style);
  { attributes }
  rb_define_attr(cControl, 'parent', 1, 0);

  cWinControl := OutputPersistentClass(mPhi, TWinControl, cControl, nil);
  rb_define_method(cWinControl, 'focused?', @Control_focused_p, 0);
  rb_define_method(cWinControl, 'set_focus', @Control_set_focus, 0);
  rb_define_method(cWinControl, 'scale_by', @Control_scale_by, 2);
  rb_define_method(cWinControl, 'invalidate', @Control_invalidate, 0);
  rb_define_method(cWinControl, 'update', @Control_update, 0);
  rb_define_method(cWinControl, 'repaint', @Control_repaint, 0);
  rb_define_method(cWinControl, 'refresh', @Control_refresh, 0);
  DefineMethod(cWinControl, 'controls', Control_get_controls);
  DefineAttrGet(cWinControl, 'control_count', Control_get_control_count);

  rb_define_method(cWinControl, 'stop_align', @Control_stop_align, 0);
  rb_define_method(cWinControl, 'handle_needed', @Control_handle_needed, 0);
  rb_define_method(cWinControl, 'control_at', @Control_control_at, 1);
  rb_define_method(cWinControl, 'select_first', @Control_select_first, 0);
  rb_define_method(cWinControl, 'select_next', @Control_select_next, 3);
  rb_define_method(cWinControl, 'showing?', @Control_showing_p, 0);
{$IFDEF VCL}
  DefineAttrSet(cWinControl, 'double_buffered', Control_set_double_buffered);
  DefineAttrGet(cWinControl, 'double_buffered', Control_get_double_buffered);
{$ENDIF}
  rb_define_method(cWinControl, 'client_rect', @Control_client_rect, 0);
  rb_define_method(cWinControl, 'adjusted_client_rect', @Control_adjusted_client_rect, 0);
end;

end.
