unit uFont;

interface

uses
  TypInfo,
{$IFDEF VCL}
  Graphics,
{$ELSE}
  QGraphics,
{$ENDIF}
  Rubies, uIntern, uAlloc, uProp;

var
  cFont: Tvalue;

function ap_cFont: Tvalue;
function ap_iFont(real: TFont; owner: Tvalue): Tvalue;
procedure Init_Font;

implementation

uses uPhi;

function ap_cFont: Tvalue;
begin
  result := cFont;
end;

function Font_alloc(klass: Tvalue; real: TFont): Tvalue;
begin
  result := TmpAlloc(klass, real);
end;

function ap_iFont(real: TFont; owner: Tvalue): Tvalue;
begin
  result := Font_alloc(cFont, real);
  ap_owner(result, owner);
end;

function Font_new(This: Tvalue): Tvalue; cdecl;
var
  real: TFont;
begin
  real := TFont.Create;
  result := ObjAlloc(This, real);

  ap_obj_call_init(result, 0, nil);
end;

function Font_to_s(This: Tvalue): Tvalue; cdecl;
var
  real: TFont;
  klass: Tvalue;
begin
  real := ap_data_get_struct(This);

  result := rb_str_new2('#');
  rb_str_cat(result, '<', 1);

  klass := CLASS_OF(This);
  klass := rb_class_path(klass);
  rb_str_concat(result, klass);
  rb_str_cat(result, ':', 1);

  ap_str_cat(result, ' name=');
  rb_str_concat(result, ap_get_str_prop(real, 'Name', '"'));
  ap_str_cat(result, ' charset=');
  ap_str_cat(result, GetEnumProp1(real, 'Charset'));
  ap_str_cat(result, ' height=');
  ap_str_cat_int(result, GetOrdProp(real, 'Height'));
  ap_str_cat(result, ' color=');
  ap_str_cat(result, GetEnumProp1(real, 'Color'));
  ap_str_cat(result, ' style=');
  ap_str_cat(result, GetSetProp1(real, 'Style', True));
  ap_str_cat(result, ' pitch=');
  ap_str_cat(result, GetEnumProp1(real, 'Pitch'));

  rb_str_cat(result, '>', 1);
end;

procedure Init_Font;
begin
  OutputConstSetType(mPhi, TypeInfo(TFontPitch));
  OutputConstSetType(mPhi, TypeInfo(TFontStyle));

  cFont := rb_define_class_under(mPhi, 'Font', ap_cObject);
  OutputProp(cFont, TFont);

  rb_define_singleton_method(cFont, 'new', @Font_new, 0);
  rb_define_method(cFont, 'to_s', @Font_to_s, 0);
end;

end.
