unit uForm;

interface

uses
{$IFDEF VCL}
  Forms,
{$ELSE}
  QForms,
{$ENDIF}
  Rubies;

var
  cForm: Tvalue;

function ap_cForm: Tvalue;
procedure Form_setup(obj: Tvalue; real: TForm);
function ap_iForm(real: TForm; owner: Tvalue): Tvalue;
procedure FormSetParent(real: TForm; name: PChar);
procedure Init_form;

implementation

uses
{$IFDEF MSWINDOWS}
  Windows,
{$ELSE}
  Libc,
{$ENDIF}
  SysUtils, Classes,
{$IFDEF VCL}
  Controls,
{$ELSE}
  QControls,
{$ENDIF}
  PhiForm,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uFont, uCanvas, uScreen, uBitmap, uControlScrollBar,
  uPersistent, uControl;

function ap_cForm: Tvalue;
begin
  result := cForm;
end;

procedure Form_setup(obj: Tvalue; real: TForm);
var
  ceo: Tvalue;
begin
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@horz_scroll_bar', ap_iControlScrollBar(real.HorzScrollBar, obj));
  rb_iv_set(obj, '@vert_scroll_bar', ap_iControlScrollBar(real.VertScrollBar, obj));
  ap_set_child_attr_module(obj);
  ceo := vScreen;
  rb_iv_set(obj, '@parent', ceo);
//    AssignPropMethod(real, [Handle]);
  if @real.OnClose = nil then real.OnClose := Handle.CloseOnClose;
end;

function Form_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function Form_alloc(This: Tvalue; real: TForm): Tvalue;
begin
  result := ChildAlloc(This, real);
  Form_setup(result, real);
end;

function ap_iForm(real: TForm; owner: Tvalue): Tvalue;
begin
  result := Form_alloc(cForm, real);
  ap_owner(result, owner);
end;

function ap_iForm_v(var AControl; owner: Tvalue): Tvalue;
var
  real: TForm;
begin
  real := TForm(AControl);
  result := FormAlloc(cForm, real);
  Form_setup(result, real);
end;

procedure FormSetParent(real: TForm; name: PChar);
var
  obj, ceo, module: Tvalue;
begin
  obj := real.tag;
  ceo := vScreen; // rb_iv_get(obj, '@parent');
  rb_iv_set(ceo, PChar('@'+name), obj);
  module := rb_iv_get(ceo, '@child_attr_module');
  rb_define_attr(module, name, 1, 0);
  real.name := name;
end;
(*
function FormAlloc(klass: Tvalue; real: TComponent): Tvalue;
begin
//  if real = nil then begin result := Qnil; exit; end;
  result := rb_data_object_alloc(klass, real, nil, @FormRelease);
end;
*)
function Form_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TForm;
  args: array of Tvalue;
begin
  SetLength(args, argc);
  args := argv;

//  real := nil;
//  result := FormAlloc(This, real);
  result := rb_data_object_alloc(This, nil, nil, @FormRelease);
  real := TPhiForm.Create(nil);

  real.width  := 320;
  real.height := 200;
  real.left := (Screen.width  - real.width ) div 2;
  real.top  := (Screen.height - real.height) div 2;

//  result := FormAlloc(This, real);
  PRData(result)^.data := real;
//  if debug_p and Assigned(Stdout) then
//    Stdout(PChar(Format('FormAlloc: %s(%s)'+NL, [real.name, real.classname])));
  PhiObjectList.Add(real);
  rb_iv_set(result, '@events', rb_hash_new);
  real.tag := result;

  Form_setup(result, real);
//  real.Show;

  if argc > 0 then
    FormSetParent(real, dl_caption(args[0]));

  if argc > 1 then
    rb_funcall2(result, rb_intern('caption='), 1, @args[1]);

  ap_obj_call_init(result, argc, argv);
end;

function Form_close(This: Tvalue): Tvalue; cdecl;
var
  real: TForm;
begin
  real := ap_data_get_struct(This);
  real.Close;
  result := This;
end;

function Form_show(This: Tvalue): Tvalue; cdecl;
var
  real: TForm;
begin
  real := ap_data_get_struct(This);
  real.Show;
  result := This;
end;

function Form_show_modal(This: Tvalue): Tvalue; cdecl;
var
  real: TForm;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ShowModal);
end;

{$IFDEF VCL}
function Form_get_bitmap(This: Tvalue): Tvalue; cdecl;
var
  real: TForm;
begin
  real := ap_data_get_struct(This);
  result := ap_iBitmap(real.GetFormImage, This);
end;
{$ENDIF}

function Form_get_active_control(This: Tvalue): Tvalue; cdecl;
var
  real: TForm;
  AControl: TWinControl;
begin
  real := ap_data_get_struct(This);
  AControl := real.ActiveControl;
  if AControl = nil then
    result := Qnil
  else
    result := AControl.tag;
end;

function Form_set_active_control(This, v: Tvalue): Tvalue; cdecl;
var
  real: TForm;
  Control: TWinControl;
begin
  real := ap_data_get_struct(This);
  Control := ap_data_get_struct(v);
  real.ActiveControl := Control;
  result := v;
end;

function Form_get_modal_result(this: Tvalue): Tvalue; cdecl;
var
  real: TForm;
begin
  real := ap_data_get_struct(this);
  result := INT2FIX(real.ModalResult);
end;

function Form_set_modal_result(this, v: Tvalue): Tvalue; cdecl;
var
  real: TForm;
begin
  real := ap_data_get_struct(this);
  real.ModalResult := FIX2INT(v);
  result := v;
end;

function Form_get_canvas(This: Tvalue): Tvalue; cdecl;
begin
  result := rb_iv_get(This, '@canvas');
end;

function Form_get_active(This: Tvalue): Tvalue; cdecl;
var
  real: TForm;
begin
  real := ap_data_get_struct(this);
  result := ap_bool(real.Active);
end;

{$IFDEF VCL}
function Form_copy_data(This, recv, str: Tvalue): Tvalue; cdecl;
var
  real: TPhiForm;
begin
  real := ap_data_get_struct(this);
  real.CopyData(FIX2INT(recv), dl_String(str));
  result := This;
end;

function Form_get_short_cut_enabled(This: Tvalue): Tvalue; cdecl;
var
  real: TPhiForm;
begin
  real := ap_data_get_struct(this);
  result := ap_bool(real.ShortCutEnabled);
end;

function Form_set_short_cut_enabled(This,v: Tvalue): Tvalue; cdecl;
var
  real: TPhiForm;
begin
  real := ap_data_get_struct(this);
  real.ShortCutEnabled := RTEST(v);
  result := This;
end;
{$ENDIF}

{$IFDEF MSWINDOWS}
function Form_bring_to_front_ex(This: Tvalue): Tvalue; cdecl;
var
  Handle: HWnd;
  real : TForm;
  nForegroundID, nTargetID: Integer;
begin
  result := This;
  real := ap_data_get_struct(This);
  Handle := real.Handle;
  if Handle <> 0 then
  begin
    if  IsWindowVisible(Handle)
    and IsWindowEnabled(Handle) then
    begin
      nForegroundID := GetWindowThreadProcessId(GetForegroundWindow(), nil);
      nTargetID := GetWindowThreadProcessId(Handle, nil);
      AttachThreadInput(nTargetID, nForegroundID, True);
      SetForegroundWindow(Handle);
      AttachThreadInput(nTargetID, nForegroundID, False);
    end;
  end;
end;
{$ENDIF}

procedure Init_Form;
begin
  RegisterClass(TPhiForm);
  PhiAllocFuncList.AddObject('TPhiForm', @ap_iForm_v);

  OutputConstSetType(mPhi, TypeInfo(TWindowState));
  OutputConstSetType(mPhi, TypeInfo(TPosition));
  OutputConstSetType(mPhi, TypeInfo(TFormStyle));

  cForm := OutputPersistentClass(mPhi, TForm, cWinControl, ap_iForm_v);

  rb_define_method(cForm, 'event_handle', @Form_event_handle, 1);
  DefineSingletonMethod(cForm, 'new', Form_new);
  rb_define_method(cForm, 'close', @Form_close, 0);
  rb_define_method(cForm, 'show', @Form_show, 0);
  rb_define_method(cForm, 'show_modal', @Form_show_modal, 0);
  // vcl: GetFormImage
{$IFDEF VCL}
  rb_define_method(cForm, 'get_bitmap', @Form_get_bitmap, 0);
{$ENDIF}

  DefineAttrGet(cForm, 'focus_control', Form_get_active_control);
  DefineAttrSet(cForm, 'focus_control', Form_set_active_control);
  DefineAttrGet(cForm, 'canvas', Form_get_canvas);
  DefineAttrGet(cForm, 'modal_result', Form_get_modal_result);
  DefineAttrSet(cForm, 'modal_result', Form_set_modal_result);
  DefineAttrGet(cForm, 'active', Form_get_active);
{$IFDEF VCL}
  rb_define_method(cForm, 'copy_data', @Form_copy_data, 2);
{$ENDIF}

  OutputAttrMethod_retval(cForm, 'on_close');
  OutputAttrMethod_retval(cForm, 'on_close_query');
//  OutputAttrMethod(cForm, 'on_create_params');
  OutputAttrMethod(cForm, 'on_drop_files');
  OutputAttrMethod(cForm, 'on_copy_data');
{$IFDEF VCL}
  DefineAttrGet(cForm, 'short_cut_enabled', Form_get_short_cut_enabled);
  DefineAttrSet(cForm, 'short_cut_enabled', Form_set_short_cut_enabled);
{$ENDIF}
{$IFDEF MSWINDOWS}
  rb_define_method(cForm, 'bring_to_front_ex', @Form_bring_to_front_ex, 0);
{$ENDIF}
end;

end.
