unit uMenu;

interface

uses
{$IFDEF VCL}
  Menus,
{$ELSE}
  QMenus,
{$ENDIF}
  Rubies;

var
  cMenu, cMainMenu, cPopupMenu: Tvalue;

function ap_cMainMenu: Tvalue;
function ap_iMainMenu(real: TMainMenu; owner: Tvalue): Tvalue;
function ap_cPopupMenu: Tvalue;
function ap_iPopupMenu(real: TPopupMenu; owner: Tvalue): Tvalue;
procedure Init_Menu;

implementation

uses
  SysUtils, Classes, uStrUtils, uDefUtils,
  uIntern, uHandle, uAlloc, uProp, uPhi, uPoint,
  uPersistent, uComponent, uMenuItem;

{ Menu building functions }

procedure InitMenuItems(AMenu: TMenu; Items: array of TMenuItem);
var
  I: Integer;
begin
  for I := Low(Items) to High(Items) do
    AMenu.Items.Add(Items[I]);
end;

function NewMenu(Owner: TComponent; const AName: string; Items: array of TMenuItem): TMainMenu;
begin
  Result := TMainMenu.Create(Owner);
  Result.Name := AName;
  InitMenuItems(Result, Items);
end;

function NewPopupMenu(Owner: TComponent; const AName: string; Alignment: TPopupAlignment; AutoPopup: Boolean; Items: array of TMenuItem): TPopupMenu;
begin
  Result := TPopupMenu.Create(Owner);
  Result.Name := AName;
  Result.AutoPopup := AutoPopup;
  Result.Alignment := Alignment;
  InitMenuItems(Result, Items);
end;

function ap_cMainMenu: Tvalue;
begin
  result := cMainMenu;
end;

procedure MainMenu_setup(obj: Tvalue; real: TMainMenu);
begin
  rb_iv_set(obj, '@items', ap_iMenuItem(real.items, obj));
  rb_iv_set(obj, '@merged', rb_ary_new());
  ap_set_child_attr_module(obj);
//    AssignPropMethod(real, [Handle]);
end;

function MainMenu_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function MainMenu_alloc(This: Tvalue; real: TMainMenu): Tvalue;
begin
  result := ChildAlloc(This, real);
  MainMenu_setup(result, real);
end;

function ap_iMainMenu(real: TMainMenu; owner: Tvalue): Tvalue;
begin
  result := MainMenu_alloc(cMainMenu, real);
  ap_owner(result, owner);
end;

function ap_iMainMenu_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iMainMenu(TMainMenu(obj), owner);
end;

function MainMenu_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TMainMenu;
  args: array of Tvalue;
  ceo: Tvalue;
begin
  real := TMainMenu.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  MainMenu_setup(result, real);

  SetLength(args, argc);
  args := argv;
  ceo := args[0];
  rb_iv_set(result, '@parent', ceo);

  ap_obj_call_init(result, argc, argv);
end;

function Phi_new_menu(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  ceo: Tvalue;
  parent: TComponent;
  aname: PChar;
  vtems: array of Tvalue;
  items: array of TMenuItem;
  ary: Tvalue;
  ptr: Pvalue;
  len: Integer;
  i: Integer;
  real: TMainMenu;
  item: TMenuItem;
begin
  if argc < 3 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;

  ceo := args[0];
  ap_data_get_object(ceo, TComponent, parent);
  aname := dl_caption(args[1]);
  ary := args[2];
  Check_Type(ary, T_ARRAY);
  ptr := ap_ary_ptr(ary);
  len := ap_ary_len(ary);
  SetLength(items, len);
  SetLength(vtems, len);
  for i := 0 to len-1 do
  begin
    vtems[i] := ptr^;
    ap_data_get_object(ptr^, TMenuItem, item);
    items[i] := item;
    Inc(ptr);
  end;

  real := NewMenu(parent, aname, items);
  result := ChildAlloc(cMainMenu, real);

  MainMenu_setup(result, real);

  SetParentAttr(result, ceo, aname);
  rb_iv_set(result, '@parent', ceo);
  DefineMenuItem(real, real.items);
end;

function MainMenu_merge(This, item: Tvalue): Tvalue; cdecl;

  procedure loop_merge(This, item: Tvalue);
  var
    ary: Tvalue;
    ptr: Pvalue;
    len: Integer;
  begin
    if item = This then
      ap_raise(ap_eArgError, 'loop merge');

    ary := rb_iv_get(This, '@merged');
    ptr := ap_ary_ptr(ary);
    len := ap_ary_len(ary);
    while len > 0 do
    begin
      loop_merge(ptr^, item);
      Inc(ptr);
      Dec(len);
    end;
  end;

var
  real, menu: TMainMenu;
  ary, includes: Tvalue;
begin
  loop_merge(This, item);

  real := ap_data_get_struct(This);
  ap_data_get_object(item, TMainMenu, menu);
  ary := rb_iv_get(item, '@merged');
  includes := rb_ary_includes(ary, This);
  if not RTEST(includes) then rb_ary_push(ary, This);
  real.Merge(menu);

  result := This;
end;

function MainMenu_unmerge(This, item: Tvalue): Tvalue; cdecl;
var
  real, menu: TMainMenu;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(item, TMainMenu, menu);
  rb_ary_delete(rb_iv_get(item, '@merged'), This);
  real.Unmerge(menu);

  result := This;
end;

function ap_cPopupMenu: Tvalue;
begin
  result := cPopupMenu;
end;

procedure PopupMenu_setup(obj: Tvalue; real: TPopupMenu);
begin
  rb_iv_set(obj, '@items', ap_iMenuItem(real.items, obj));
  ap_set_child_attr_module(obj);
//    AssignPropMethod(real, [Handle]);
end;

function PopupMenu_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function PopupMenu_alloc(This: Tvalue; real: TPopupMenu): Tvalue;
begin
  result := ChildAlloc(cPopupMenu, real);
  PopupMenu_setup(result, real);
end;

function ap_iPopupMenu(real: TPopupMenu; owner: Tvalue): Tvalue;
begin
  result := PopupMenu_alloc(cPopupMenu, real);
  ap_owner(result, owner);
end;

function ap_iPopupMenu_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iPopupMenu(TPopupMenu(obj), owner);
end;

function PopupMenu_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TPopupMenu;
begin
  real := TPopupMenu.Create(nil);
  result := ChildAlloc(This, real);
  CompoSetup(argc, argv, real);
  PopupMenu_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function Phi_new_popup_menu(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  ceo: Tvalue;
  parent: TComponent;
  aname: PChar;
  vtems: array of Tvalue;
  items: array of TMenuItem;
  ary: Tvalue;
  ptr: Pvalue;
  len: Integer;
  i: Integer;
  real: TPopupMenu;
begin
  if argc < 3 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;

  ceo := args[0];
  ap_data_get_object(ceo, TComponent, parent);
  aname := dl_caption(args[1]);
  ary := args[2];
  ptr := ap_ary_ptr(ary);
  len := ap_ary_len(ary);
  SetLength(items, len);
  SetLength(vtems, len);
  for i := 0 to len-1 do
  begin
    vtems[i] := ptr^;
    items[i] := TMenuItem(ap_data_get_struct(ptr^));
    Inc(ptr);
  end;

  real := NewPopupMenu(parent, aname, paCenter, True, items);
  result := CompoAlloc(cPopupMenu, real);

  PopupMenu_setup(result, real);

  SetParentAttr(result, ceo, aname);
  rb_iv_set(result, '@parent', ceo);
  DefineMenuItem(real, real.items);
end;

function PopupMenu_popup(This, x, y: Tvalue): Tvalue; cdecl;
var
  real: TPopupMenu;
begin
  real := ap_data_get_struct(This);
  real.Popup(FIX2INT(x), FIX2INT(y));
  result := This;
end;

function PopupMenu_get_popup_point(This: Tvalue): Tvalue; cdecl;
var
  real: TPopupMenu;
begin
  real := ap_data_get_struct(This);
  result := ap_iPoint(real.PopupPoint, This);
end;

function PopupMenu_get_popup_component(This: Tvalue): Tvalue; cdecl;
var
  real: TPopupMenu;
  Component: TComponent;
begin
  real := ap_data_get_struct(This);
  Component := real.PopupComponent;
  if Component = nil then
    result := Qnil
  else
    result := Component.tag
  ;
end;

function PopupMenu_set_popup_component(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPopupMenu;
  Component: TComponent;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TComponent, Component);
  real.PopupComponent := Component;
  result := v;
end;

procedure Init_Menu;
begin
  OutputConstSetType(mPhi, TypeInfo(TMenuItemAutoFlag));

  cMenu := OutputPersistentClass(mPhi, TMenu, cComponent, nil);

  cMainMenu := OutputPersistentClass(mPhi, TMainMenu, cMenu, ap_iMainMenu_v);
  rb_define_method(cMainMenu, 'event_handle', @MainMenu_event_handle, 1);
  DefineSingletonMethod(cMainMenu, 'new', MainMenu_new);
  DefineModuleFunction(mPhi, 'new_menu', Phi_new_menu);
  rb_define_method(cMainMenu, 'merge', @MainMenu_merge, 1);
  rb_define_method(cMainMenu, 'unmerge', @MainMenu_unmerge, 1);
  rb_define_attr(cMainMenu, 'parent', 1, 0);

  cPopupMenu := OutputPersistentClass(mPhi, TPopupMenu, cMenu, ap_iPopupMenu_v);
  rb_define_method(cPopupMenu, 'event_handle', @PopupMenu_event_handle, 1);
  DefineSingletonMethod(cPopupMenu, 'new', PopupMenu_new);
  DefineModuleFunction(mPhi, 'new_popup_menu', Phi_new_popup_menu);
  rb_define_attr(cPopupMenu, 'parent', 1, 0);
  rb_define_method(cPopupMenu, 'popup', @PopupMenu_popup, 2);
  DefineAttrGet(cPopupMenu, 'popup_point', PopupMenu_get_popup_point);
  DefineAttrGet(cPopupMenu, 'popup_component', PopupMenu_get_popup_component);
  DefineAttrSet(cPopupMenu, 'popup_component', PopupMenu_set_popup_component);
end;

end.
