unit uPaintBox;

interface

uses
{$IFDEF VCL}
  ExtCtrls,
{$ELSE}
  QExtCtrls,
{$ENDIF}
  Rubies;

var
  cPaintBox: Tvalue;

function ap_cPaintBox: Tvalue;
function ap_iPaintBox(real: TPaintBox; owner: Tvalue): Tvalue;
procedure Init_PaintBox;

implementation

uses
  Classes,
{$IFDEF VCL}
  Graphics,
{$ELSE}
  QGraphics,
{$ENDIF}
  uDefUtils, uHandle, uIntern, uAlloc, uProp, uPhi,
  uPersistent, uComponent, uControl, uPicture, uCanvas;

function ap_cPaintBox: Tvalue;
begin
  result := cPaintBox;
end;

procedure PaintBox_setup(obj: Tvalue; real: TPaintBox);
begin
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
//    AssignPropMethod(real, [Handle]);
end;

function PaintBox_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function PaintBox_alloc(This: Tvalue; real: TPaintBox): Tvalue;
begin
  result := TmpAlloc(This, real);
  PaintBox_setup(result, real);
end;

function ap_iPaintBox(real: TPaintBox; owner: Tvalue): Tvalue;
begin
  result := PaintBox_alloc(cPaintBox, real);
  ap_owner(result, owner);
end;

function ap_iPaintBox_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iPaintBox(TPaintBox(AControl), owner)
end;

function PaintBox_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TPaintBox;
begin
  real := TPaintBox.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  PaintBox_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

procedure Init_PaintBox;
begin
  cPaintBox := OutputPersistentClass(mPhi, TPaintBox, cControl, ap_iPaintBox_v);
  rb_define_method(cPaintBox, 'event_handle', @PaintBox_event_handle, 1);
  DefineSingletonMethod(cPaintBox, 'new', PaintBox_new);
  rb_define_attr(cPaintBox, 'canvas', 1, 0);
end;

end.
