unit uPersistent;

interface

uses Rubies, SysUtils, Classes;

var
  cPersistent: Tvalue;

function ap_cPersistent: Tvalue;
function DefinePersistentClass(module: Tvalue; AClass: TPersistentClass; super: Tvalue; func: TAllocFunc): Tvalue;
function OutputPersistentClass(module: Tvalue; AClass: TPersistentClass; super: Tvalue; func: TAllocFunc): Tvalue;
procedure Init_Persistent;

implementation

uses
  uDefUtils, uHandle, uError, uPhi, uProp;

function ap_cPersistent: Tvalue;
begin
  result := cPersistent;
end;

function DefinePersistentClass(module: Tvalue; AClass: TPersistentClass; super: Tvalue; func: TAllocFunc): Tvalue;
var
  v, t: Tvalue;
  S: string;
  i: Integer;
begin
  v := cPersistent;
//  writeln(AClass.ClassName, ': ', rb_class2name(super), ' <=> ', rb_class2name(v));
  t := rb_funcall2(super, rb_intern('>'), 1, @v);
  if RTEST(t) then
    ap_raise(ap_eDelphiError, AClass.ClassName +': '+ rb_class2name(super)+ ' > ' +rb_class2name(v)+ ' in DefinePersistentClass');
  try
    RegisterClass(AClass);
  except
    on E: EFilerError do;
  end;
  S := AClass.ClassName;
  PhiAllocFuncList.AddObject(S, @func);
  i := 1;
  if Copy(S, 1, 5) = 'TPhi_' then i := 5;
  result := rb_define_class_under(module, PChar(S)+i, super);
  rb_iv_set(result, '_class', rb_data_object_alloc(ap_cObject, AClass.ClassInfo, nil, nil));
  DefineProp(result, AClass);
  rb_ary_push(vPhiComponents, result);
end;

function OutputPersistentClass(module: Tvalue; AClass: TPersistentClass; super: Tvalue; func: TAllocFunc): Tvalue;
var
  v, t: Tvalue;
  S: string;
  i: Integer;
begin
  v := cPersistent;
//  writeln(AClass.ClassName, ': ', rb_class2name(super), ' <=> ', rb_class2name(v));
  t := rb_funcall2(super, rb_intern('>'), 1, @v);
  if RTEST(t) then
    ap_raise(ap_eDelphiError, AClass.ClassName +': '+ rb_class2name(super)+ ' > ' +rb_class2name(v)+ ' in OutputPersistentClass');
  try
    RegisterClass(AClass);
  except
    on E: EFilerError do;
  end;
  S := AClass.ClassName;
  PhiAllocFuncList.AddObject(S, @func);
  i := 1;
  if Copy(S, 1, 5) = 'TPhi_' then i := 5;
  result := rb_define_class_under(module, PChar(S)+i, super);
  rb_iv_set(result, '_class', rb_data_object_alloc(ap_cObject, AClass.ClassInfo, nil, nil));
  OutputProp(result, AClass);
  rb_ary_push(vPhiComponents, result);
end;

procedure Init_Persistent;
begin
  cPersistent := rb_define_class_under(mPhi, 'Persistent', ap_cObject);
end;

end.
