unit uPrinter;

interface

uses
{$IFDEF VCL}
  Printers,
{$ELSE}
  QPrinters,
{$ENDIF}
  Rubies;

var
  cPrinter: Tvalue;
  vPrinter: Tvalue;

function ap_cPrinter: Tvalue;
function ap_vPrinter: Tvalue;
procedure Init_Printer;

implementation

uses uDefUtils, uAlloc, uProp, uPhi, uConv, uStrings;

function ap_cPrinter: Tvalue;
begin
  result := cPrinter;
end;

function ap_vPrinter: Tvalue;
begin
  result := vPrinter;
end;

{$IFDEF VCL}
procedure SetPrinter;
var
  Device, Driver, Port: array[0..512] of Char;
  hDev: THandle;
begin
  Printer.GetPrinter(Device, Driver, Port, hDev);
  Printer.SetPrinter(Device, Driver, Port, 0);
end;

function Printer_get_printer_index(This: Tvalue): Tvalue; cdecl;
var
  real: TPrinter;
begin
  real := ap_data_get_struct(This);
  result := ap_Fixnum(real.PrinterIndex);
  SetPrinter;
end;

function Printer_set_printer_index(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPrinter;
begin
  real := ap_data_get_struct(This);
  real.PrinterIndex := dl_Integer(v);
  result := v;
end;
{$ENDIF}

function Printer_get_printers(This: Tvalue): Tvalue; cdecl;
var
  real: TPrinter;
begin
  real := ap_data_get_struct(This);
  result := ap_iStrings(real.Printers, This);
end;

function Printer_get_title(This: Tvalue): Tvalue; cdecl;
var
  real: TPrinter;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.Title);
end;

function Printer_set_title(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPrinter;
begin
  real := ap_data_get_struct(This);
  real.Title := dl_String(v);
  result := v;
end;

function Printer_instance(This: Tvalue): Tvalue; cdecl;
begin
  result := vPrinter;
end;

procedure Regist_Printer;
var
  real: TPrinter;
  obj: Tvalue;
begin
  real := Printer;
  obj := TmpAlloc(cPrinter, real);
  vPrinter := obj;
  rb_define_const(mPhi, 'PRINTER', obj);
end;

procedure Init_Printer;
begin
  cPrinter := rb_define_class_under(mPhi, 'Printer', ap_cObject);
//  OutputProp(cPrinter, TPrinter);

  rb_undef_method(CLASS_OF(cPrinter), 'new');
  rb_define_singleton_method(cPrinter, 'instance', @Printer_instance, 0);

{$IFDEF VCL}
  DefineAttrGet(cPrinter, 'printer_index', Printer_get_printer_index);
  DefineAttrSet(cPrinter, 'printer_index', Printer_set_printer_index);
{$ENDIF}
  DefineAttrGet(cPrinter, 'printers', Printer_get_printers);
  DefineAttrGet(cPrinter, 'title', Printer_get_title);
  DefineAttrSet(cPrinter, 'title', Printer_set_title);

  Regist_Printer;
end;

end.
