unit uScreen;

interface

uses
{$IFDEF VCL}
  Forms,
{$ELSE}
  QForms,
{$ENDIF}
  Rubies;

var
  cScreen: Tvalue;
  vScreen: Tvalue;

function ap_cScreen: Tvalue;
function ap_vScreen: Tvalue;
procedure Init_Screen;

implementation

uses uDefUtils, uAlloc, uProp, uPhi,
{$IFDEF VCL}
  uRect,
{$ENDIF}
  uStrings;

function ap_cScreen: Tvalue;
begin
  result := cScreen;
end;

function ap_vScreen: Tvalue;
begin
  result := vScreen;
end;

function Screen_get_height(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.height);
end;

function Screen_get_width(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.width);
end;

function Screen_get_cursor(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.cursor);
end;

function Screen_get_active_control(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := real.ActiveControl.tag;
end;

function Screen_get_active_form(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := real.ActiveForm.tag;
end;

function Screen_set_cursor(This, v: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  real.cursor := FIX2INT(v);
  result := v;
end;

function Screen_get_cursors(This, index: Tvalue): Tvalue; cdecl;
{$IFDEF VCL}
var
  real: TScreen;
{$ENDIF}
begin
{$IFDEF VCL}
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Cursors[FIX2INT(index)]);
{$ELSE}
  result := Qnil;
{$ENDIF}
end;

function Screen_set_cursors(This, index, cur: Tvalue): Tvalue; cdecl;
{$IFDEF VCL}
var
  real: TScreen;
{$ENDIF}
begin
{$IFDEF VCL}
  real := ap_data_get_struct(This);
  real.Cursors[FIX2INT(index)] := FIX2INT(cur);
{$ENDIF}
  result := cur;
end;

function Screen_get_forms(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
  I: Integer;
  obj: Tvalue;
begin
  real := ap_data_get_struct(This);
  result := rb_ary_new;
  for I := 0 to real.FormCount-1 do
  begin
    obj := real.Forms[I].tag;
    if obj = 0 then Continue;
    rb_ary_push(result, obj);
  end;
end;

function Screen_get_form_count(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.FormCount);
end;

function Screen_instance(This: Tvalue): Tvalue; cdecl;
begin
  result := vScreen;
end;

procedure Regist_Screen;
var
  real: TScreen;
  obj, module: Tvalue;
begin
  real := Screen;
  obj := ChildAlloc(cScreen, real);
  vScreen := obj;
  rb_define_const(mPhi, 'SCREEN', obj);
  rb_iv_set(obj, '@fonts', ap_iStrings(real.Fonts, obj));
{$IFDEF VCL}
  rb_iv_set(obj, '@imes', ap_iStrings(real.Imes, obj));
  rb_iv_set(obj, '@default_ime', rb_str_new2(PChar(real.DefaultIme)));
{$ENDIF}

  module := rb_module_new;
  rb_extend_object(obj, module);
  rb_iv_set(obj, '@child_attr_module', module);
end;

{$IFDEF VCL}
function Screen_get_work_area_height(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.WorkAreaHeight);
end;

function Screen_get_work_area_left(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.WorkAreaLeft);
end;

function Screen_get_work_area_rect(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := ap_iRect(real.WorkAreaRect, This);
end;

function Screen_get_work_area_top(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.WorkAreaTop);
end;

function Screen_get_work_area_width(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.WorkAreaWidth);
end;
{$ENDIF}

procedure Init_Screen;
begin
  cScreen := rb_define_class_under(mPhi, 'Screen', ap_cObject);
  OutputProp(cScreen, TScreen);

  rb_undef_method(CLASS_OF(cScreen), 'new');
  rb_define_singleton_method(cScreen, 'instance', @Screen_instance, 0);

  DefineAttrGet(cScreen, 'height', Screen_get_height);
  DefineAttrGet(cScreen, 'width', Screen_get_width);

  DefineAttrGet(cScreen, 'active_control', Screen_get_active_control);
  DefineAttrGet(cScreen, 'active_form', Screen_get_active_form);
  DefineAttrGet(cScreen, 'cursor', Screen_get_cursor);
  DefineAttrSet(cScreen, 'cursor', Screen_set_cursor);
  rb_define_method(cScreen, 'get_cursors', @Screen_get_cursors, 1);
  rb_define_method(cScreen, 'set_cursors', @Screen_set_cursors, 2);
  DefineAttrGet(cScreen, 'forms', Screen_get_forms);
  DefineAttrGet(cScreen, 'form_count', Screen_get_form_count);
  rb_define_attr(cScreen, 'fonts', 1, 0);
  rb_define_attr(cScreen, 'imes', 1, 0);
  rb_define_attr(cScreen, 'default_ime', 1, 0);
{$IFDEF VCL}
  DefineAttrGet(cScreen, 'work_area_height', Screen_get_work_area_height);
  DefineAttrGet(cScreen, 'work_area_left', Screen_get_work_area_left);
  DefineAttrGet(cScreen, 'work_area_rect', Screen_get_work_area_rect);
  DefineAttrGet(cScreen, 'work_area_top', Screen_get_work_area_top);
  DefineAttrGet(cScreen, 'work_area_width', Screen_get_work_area_width);
{$ENDIF}

  Regist_Screen;
end;

end.
