#!/usr/bin/ruby

APOLLO_5_DIR = 'C:\apollo'
DELPHI_5_DIR = 'C:\borland\delphi5'

begin
  require '5to6_opt'
rescue
  APOLLO_6_DIR = 'C:\apollo'
  DELPHI_6_DIR = 'C:\borland\delphi6'
end

DELPHI_6_PKG_ENTERPRISE = <<EOT
vcl;rtl;dbrtl;adortl;vcldb;vclx;bdertl;vcldbx;ibxpress;dsnap;cds;bdecds;qrpt;teeui;teedb;tee;dss;teeqr;visualclx;visualdbclx;dsnapcrba;dsnapcon;VclSmp;vclshlctrls;vclie;vcljpg;xmlrtl;inet;inetdbbde;inetdbxpress;inetdb;nmfast;webdsnap;websnap;dbexpress;dbxcds;indy;dclOffice2k
EOT

DELPHI_6_PKG_PROFESSIONAL = <<EOT
vcl;rtl;dbrtl;adortl;vcldb;vclx;bdertl;vcldbx;ibxpress;cds;bdecds;qrpt;teeui;teedb;tee;teeqr;visualclx;visualdbclx;VclSmp;vclshlctrls;vclie;vcljpg;xmlrtl;inet;inetdbbde;inetdbxpress;inetdb;nmfast;dbexpress;dbxcds;indy;dclOffice2k
EOT

DELPHI_6_PKG_PERSONAL = <<EOT
vcl;rtl;vclx;VclSmp;vclshlctrls;vcljpg
EOT

edition = ARGV.shift
DELPHI_6_PKG = case edition
when /^ent/i
  DELPHI_6_PKG_ENTERPRISE
when /^pro/i
  DELPHI_6_PKG_PROFESSIONAL
when /^per/i
  DELPHI_6_PKG_PERSONAL
else
  DELPHI_6_PKG_ENTERPRISE
end

DELPHI_6_LU = '-LU' + DELPHI_6_PKG
DELPHI_6_Packages = 'Packages=' + DELPHI_6_PKG

RE_APOLLO_5_DIR = Regexp.new(Regexp.escape(APOLLO_5_DIR), true)
RE_DELPHI_5_DIR = Regexp.new(Regexp.escape(DELPHI_5_DIR), true)

Dir.chdir(APOLLO_6_DIR)

Dir.glob('**/*.cfg') {|entry|
  backup = entry + '~'
  File.rename entry, backup
  print entry, "\n"
  open(backup) {|i|
    open(entry, 'w') {|o|
      while i.gets
        gsub!(RE_APOLLO_5_DIR, APOLLO_6_DIR)
        gsub!(RE_DELPHI_5_DIR, DELPHI_6_DIR)
        sub!(/^-LU.*/, DELPHI_6_LU)
        o.print
      end
    }
  }
}

Dir.glob('**/*.dof') {|entry|
  backup = entry + '~'
  File.rename entry, backup
  print entry, "\n"
  open(backup) {|i|
    open(entry, 'w') {|o|
      while i.gets
        gsub!(RE_APOLLO_5_DIR, APOLLO_6_DIR)
        gsub!(RE_DELPHI_5_DIR, DELPHI_6_DIR)
        sub!(/^Packages=.*/, DELPHI_6_Packages)
        o.print
      end
    }
  }
}
