﻿using System;

namespace NaGet.Tasks
{
	/// <summary>
	/// NaGetのコマンドタスクの抽象クラス
	/// </summary>
	public abstract class Task
	{
		/// <summary>
		/// タスク処理のイベントハンドラ
		/// </summary>
		public virtual event EventHandler<TaskEventArgs> TaskEventRaised;
		
		/// <summary>
		/// 実行する
		/// </summary>
		public abstract void Run();
		
		/// <summary>
		/// 実行状態か否かを得る
		/// </summary>
		public abstract bool Running {
			get;
		}
		
		/// <summary>
		/// 終了しているか否か。
		/// </summary>
		public abstract bool Done {
			get;
		}
		
		/// <summary>
		/// キャンセル可能か否かを返す
		/// </summary>
		public virtual bool Cancelable {
			get { return false; }
		}
		
		/// <summary>
		/// 中断させる
		/// </summary>
		/// <returns>成功したかいなか</returns>
		public virtual bool Cancel()
		{
			return false;
		}
		
		#region TaskEvent便利メソッド
		
		protected virtual void RaiseTaskSetEvent(TaskEventType type, string message, float percent)
		{
			if (TaskEventRaised != null) {
				TaskEventRaised(this, new TaskEventArgs(type, message, percent));
			}
		}
		
		#endregion
	}
}
