/*
 * init.S: assembly language bootstrap
 */

#ifdef BOOTMODE
#define STACK_REGION	0x10000000	/* 48 kB on-chip SRAM */
#define STACK_OFFSET	0x0000C000	/* full size of SRAM */
#else
#define STACK_REGION	0xc1000000	/* second DRAM bank */
#define STACK_OFFSET	0x01000000	/* full size of DRAM bank 2 */
#endif

	.section .ram.boot
	.global _start_ram
_start_ram:
	mov	sp, #STACK_REGION	/* init stack pointer */
	add	sp, sp, #STACK_OFFSET
	bl	entry			/* see entry.c */
1:	b	1b

