/*
 * Copyright (c) 2003 Atmark Techno, Inc.  All Rights Reserved.
 */

#include <target/buffer.h>
#include <target/crc.h>
#include <target/io.h>
#include <target/frob.h>
#include <target/flash.h>
#include <target/md5sum.h>
#include "memmap.h"
#include "linux.h"
#include "mode.h"

char *target_profile = TARGET_PROFILE;

static const command_t *commands[] = {
	&help_command,
	&frob_command,
	&jump_command,
	&upload_command,
	&version_command,
        &memmap_command,
        &flash_erase_command,
        &flash_program_command,
	&download_command,
        &linux_command,
        &boot_command,
	&md5sum_command,
	0
};

ABBR(help_command, '?')
ABBR(frob_command, 'f')
ABBR(version_command, 'V')
ABBR(boot_command, 'b')

static const abbrev_t *abbrevs[] = {
	&help_command_abbrev,
	&frob_command_abbrev,
	&version_command_abbrev,
	&boot_command_abbrev,
	0
};

/* turn on red led */
static void turn_on_red_led(void)
{
	write32(XPAR_OPB_GPIO_LED_BASEADDR, 0x0);
}

int hmain(void)
{
	command_list_t command_list = { commands, abbrevs, "hermit", 0 };

	turn_on_red_led();
	flash_initialize((is_flash_spi() ? FLASH_TYPE_SPI : FLASH_TYPE_AMD),
			 FLASH_START);

        if (is_autoboot())
                (*boot_command.func)(0, 0);

	/* startup stuff: print version string */
	(*version_command.func)(0, 0);
	init_crc32();

	do_command_loop(&command_list);
	for (;;);
}

