/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#include <cs89712/ioregs.h>
#include <target/io.h>
#include "memmap.h"

/*
 * The only vaguely tricky things about this memory map are:
 *
 * (1) It includes remapped memory addresses for the inverted mapping
 *     used by the CSC in boot mode, if we're compiling for that
 *     target.
 *
 * (2) Depicts flash block sizes as they are seen from outside the
 *     boot loader.  The flash parts are 16 bits wide (each spans 16
 *     bits of the data bus), so the blocks as seen by a flash
 *     programmer are twice data sheet size (of each 32-bit write, 16
 *     bits goes to each flash chip).
 */
static int memmap_cmdfunc(int argc, char *argv[])
{
#ifdef BOOTMODE
	hprintf("%p:%p@%p FLA %s bf:8K bl:%s\n"
		"%p:%p@%p FLA %s bf:8K bl:%s\n"
		"%p:%p@%p FLA %s bf:8K bl:%s\n"
		"%p:%p@%p FLA %s bf:8K bl:%s\n"
		"%p:%p@%p FLA %s bf:8K bl:%s\n"
		"%p:%p@%p RAM onchip-sram\n"
		"%p:%p@%p ROM boot-rom\n"
		"%p:%p RAM dram-1\n",
		FLASH_BOOTLOADER_START, FLASH_BOOTLOADER_START + FLASH_BOOTLOADER_SIZE - 1, FLASH_BOOTLOADER_MAPPED,
		FLASH_BOOTLOADER_NAME, FLASH_BOOTLOADER_BLOCK,
		FLASH_KERNEL_START, FLASH_KERNEL_START + FLASH_KERNEL_SIZE - 1, FLASH_KERNEL_MAPPED,
		FLASH_KERNEL_NAME, FLASH_KERNEL_BLOCK,
		FLASH_USERLAND_START, FLASH_USERLAND_START + FLASH_USERLAND_SIZE - 1, FLASH_USERLAND_MAPPED,
		FLASH_USERLAND_NAME, FLASH_USERLAND_BLOCK,
		FLASH_CONFIG_START, FLASH_CONFIG_START + FLASH_CONFIG_SIZE - 1, FLASH_CONFIG_MAPPED,
		FLASH_CONFIG_NAME, FLASH_CONFIG_BLOCK,
		FLASH_BANK1_START, FLASH_BANK1_START + FLASH_BANK1_SIZE - 1, FLASH_BANK1_MAPPED,
		FLASH_BANK1_NAME, FLASH_BANK1_BLOCK,
		SRAM_START, SRAM_START + SRAM_SIZE - 1, SRAM_MAPPED,
		BOOTROM_START, BOOTROM_START + BOOTROM_SIZE - 1, BOOTROM_MAPPED,
		DRAM1_START, DRAM1_START + DRAM1_SIZE - 1);
#else
	hprintf("%p:%p FLA %s bf:8K bl:%s\n"
		"%p:%p FLA %s bf:8K bl:%s\n"
		"%p:%p FLA %s bf:8K bl:%s\n"
		"%p:%p FLA %s bf:8K bl:%s\n"
		"%p:%p FLA %s bf:8K bl:%s\n"
		"%p:%p RAM onchip-sram\n"
		"%p:%p ROM boot-rom\n"
		"%p:%p RAM dram-1\n",
		FLASH_BOOTLOADER_START, FLASH_BOOTLOADER_START + FLASH_BOOTLOADER_SIZE - 1,
		FLASH_BOOTLOADER_NAME, FLASH_BOOTLOADER_BLOCK,
		FLASH_KERNEL_START, FLASH_KERNEL_START + FLASH_KERNEL_SIZE - 1,
		FLASH_KERNEL_NAME, FLASH_KERNEL_BLOCK,
		FLASH_USERLAND_START, FLASH_USERLAND_START + FLASH_USERLAND_SIZE - 1,
		FLASH_USERLAND_NAME, FLASH_USERLAND_BLOCK,
		FLASH_CONFIG_START, FLASH_CONFIG_START + FLASH_CONFIG_SIZE - 1,
		FLASH_CONFIG_NAME, FLASH_CONFIG_BLOCK,
		FLASH_BANK1_START, FLASH_BANK1_START + FLASH_BANK1_SIZE - 1,
		FLASH_BANK1_NAME, FLASH_BANK1_BLOCK,
		SRAM_START, SRAM_START + SRAM_SIZE - 1,
		BOOTROM_START, BOOTROM_START + BOOTROM_SIZE - 1,
		DRAM1_START, DRAM1_START + DRAM1_SIZE - 1);
#endif /* BOOTMODE */
	return 0;
}

const command_t memmap_command =
	{ "memmap", 0, "output memory map", &memmap_cmdfunc };

