/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#include <ep93xx/ioregs.h>
#include <target/io.h>
#include "memmap.h"

#define SECTOR_TABLE_SIZE 142
static const unsigned short flash_sector_table[] = {
  /* [  0] */ 8,8,8,8,8,8,8,8,
  /* [  8] */ 64,64,64,64,64,64,64,64,
  /* [ 16] */ 64,64,64,64,64,64,64,64,
  /* [ 24] */ 64,64,64,64,64,64,64,64,
  /* [ 32] */ 64,64,64,64,64,64,64,64,
  /* [ 40] */ 64,64,64,64,64,64,64,64,
  /* [ 48] */ 64,64,64,64,64,64,64,64,
  /* [ 56] */ 64,64,64,64,64,64,64,64,
  /* [ 64] */ 64,64,64,64,64,64,64,64,
  /* [ 72] */ 64,64,64,64,64,64,64,64,
  /* [ 80] */ 64,64,64,64,64,64,64,64,
  /* [ 88] */ 64,64,64,64,64,64,64,64,
  /* [ 96] */ 64,64,64,64,64,64,64,64,
  /* [104] */ 64,64,64,64,64,64,64,64,
  /* [112] */ 64,64,64,64,64,64,64,64,
  /* [120] */ 64,64,64,64,64,64,64,64,
  /* [128] */ 64,64,64,64,64,64,
  /* [134] */ 8,8,8,8,8,8,8,8,
  /* [142] */ 0
};

unsigned int get_flash_sector_size(int sector){
  if(0 <= sector && sector <= SECTOR_TABLE_SIZE){
    return (unsigned int)(flash_sector_table[sector] * 1024);
  }
  return 0;
}

/*
 * The only vaguely tricky things about this memory map are:
 *
 * (1) It includes remapped memory addresses for the inverted mapping
 *     used by the CSC in boot mode, if we're compiling for that
 *     target.
 *
 * (2) Depicts flash block sizes as they are seen from outside the
 *     boot loader.  The flash parts are 16 bits wide (each spans 16
 *     bits of the data bus), so the blocks as seen by a flash
 *     programmer are twice data sheet size (of each 32-bit write, 16
 *     bits goes to each flash chip).
 */
static int memmap_cmdfunc(int argc, char *argv[])
{
	hprintf("%p:%p FLA %s bf:8K bl:%s\n"
		"%p:%p FLA %s bf:8K bl:%s\n"
		"%p:%p FLA %s bf:8K bl:%s\n"
		"%p:%p FLA %s bf:8K bl:%s\n"
		"%p:%p FLA %s bf:8K bl:%s\n"
		"%p:%p RAM onchip-sram\n"
		"%p:%p ROM boot-rom\n"
		"%p:%p RAM dram-1\n"
		"%p:%p RAM dram-2\n",
		FLASH_ALL_START, FLASH_ALL_START + FLASH_ALL_SIZE - 1,
		FLASH_ALL_NAME, FLASH_ALL_BLOCK,
		FLASH_BOOTLOADER_START, FLASH_BOOTLOADER_START + FLASH_BOOTLOADER_SIZE - 1,
		FLASH_BOOTLOADER_NAME, FLASH_BOOTLOADER_BLOCK,
		FLASH_KERNEL_START, FLASH_KERNEL_START + FLASH_KERNEL_SIZE - 1,
		FLASH_KERNEL_NAME, FLASH_KERNEL_BLOCK,
		FLASH_USERLAND_START, FLASH_USERLAND_START + FLASH_USERLAND_SIZE - 1,
		FLASH_USERLAND_NAME, FLASH_USERLAND_BLOCK,
		FLASH_CONFIG_START, FLASH_CONFIG_START + FLASH_CONFIG_SIZE - 1,
		FLASH_CONFIG_NAME, FLASH_CONFIG_BLOCK,
		SRAM_START, SRAM_START + SRAM_SIZE - 1,
		BOOTROM_START, BOOTROM_START + BOOTROM_SIZE - 1,
		DRAM1_START, DRAM1_START + DRAM1_SIZE - 1,
		DRAM2_START, DRAM2_START + DRAM2_SIZE - 1);
	return 0;
}

const command_t memmap_command =
	{ "memmap", 0, "output memory map", &memmap_cmdfunc };
