#include <target/io.h>
#include "memmap.h"
#include "memregions.h"

#define SECTOR_TABLE_SIZE_8MB 142
static const unsigned short flash_sector_table_8MB[] = {
  /* [  0] */ 8,8,8,8,8,8,8,8,
  /* [  8] */ 64,64,64,64,64,64,64,64,
  /* [ 16] */ 64,64,64,64,64,64,64,64,
  /* [ 24] */ 64,64,64,64,64,64,64,64,
  /* [ 32] */ 64,64,64,64,64,64,64,64,
  /* [ 40] */ 64,64,64,64,64,64,64,64,
  /* [ 48] */ 64,64,64,64,64,64,64,64,
  /* [ 56] */ 64,64,64,64,64,64,64,64,
  /* [ 64] */ 64,64,64,64,64,64,64,64,
  /* [ 72] */ 64,64,64,64,64,64,64,64,
  /* [ 80] */ 64,64,64,64,64,64,64,64,
  /* [ 88] */ 64,64,64,64,64,64,64,64,
  /* [ 96] */ 64,64,64,64,64,64,64,64,
  /* [104] */ 64,64,64,64,64,64,64,64,
  /* [112] */ 64,64,64,64,64,64,64,64,
  /* [120] */ 64,64,64,64,64,64,64,64,
  /* [128] */ 64,64,64,64,64,64,
  /* [134] */ 8,8,8,8,8,8,8,8,
  /* [142] */ 0
};

#define SECTOR_TABLE_SIZE  (SECTOR_TABLE_SIZE_8MB)
#define flash_sector_table (flash_sector_table_8MB)

unsigned int get_flash_sector_size(int sector){
	if(0 <= sector && sector <= SECTOR_TABLE_SIZE){
		return (unsigned int)(flash_sector_table[sector] * 1024);
	}
	return 0;
}

void print_map(int index)
{
	if(regions[index].name[0]){ 
		if(regions[index].type == MAP_TYPE_FLASH){ 
			PRINT_FLASH_MAP(index); 
		}else{ 
			PRINT_RAM_MAP(index);
		}
	}
}

static int memmap_cmdfunc(int argc, char *argv[])
{
	int i;
	for(i=0; i<MAX_REGION_NUM; i++){
		print_map(i);
	}
	return 0;
}

const command_t memmap_command =
	{ "memmap", 0, "output memory map", &memmap_cmdfunc };

