#include <target/htypes.h>
#include <mx3/ioregs.h>

struct serial_reg_info {
	u32 uart_base;
};

struct serial_reg_info ser_info[] = {
	[0] = { /* not support serial channel */
		.uart_base	= 0,
	},
	[1] = { /* UART1 */
		.uart_base	= UART1_BASE_ADDR,
	},
	[2] = { /* UART2 */
		.uart_base	= UART2_BASE_ADDR,
	},
	[3] = { /* UART3 */
		.uart_base	= UART3_BASE_ADDR,
	},
	[4] = { /* UART4 */
		.uart_base	= UART4_BASE_ADDR,
	},
	[5] = { /* UART5 */
		.uart_base	= UART5_BASE_ADDR,
	},
};

static unsigned int _cur_ch = 1; /* current(default) channel is "UART1" */

/****************************************************************************
 * 
 ****************************************************************************/
static int
is_bad_serial_channel(unsigned int ch)
{
	if (ch > 2)
		/* bad serial channel */
		return 1;

	return 0;
}

/****************************************************************************
 * 
 ****************************************************************************/
int
change_serial_channel(unsigned int ch)
{
	if (is_bad_serial_channel(ch))
		return -1;

	_cur_ch = ch;
	return 0;
}

/****************************************************************************
 * 
 ****************************************************************************/
int
arch_getchar(unsigned long timeout)
{
	if (is_bad_serial_channel(_cur_ch))
		return -1;

	if (!_cur_ch)
		return -1;

	while (!(IO_WORD(ser_info[_cur_ch].uart_base + USR1) & USR1_RRDY));
	return (IO_WORD(ser_info[_cur_ch].uart_base + URXD) & 0xff);
}

/****************************************************************************
 * 
 ****************************************************************************/
int
arch_putchar(int c, unsigned long timeout)
{
	if (is_bad_serial_channel(_cur_ch))
		return -1;

	if (!_cur_ch)
		return 0;

	while (!(IO_WORD(ser_info[_cur_ch].uart_base + USR2) & USR2_TXFE));
	IO_WORD(ser_info[_cur_ch].uart_base + UTXD) = c;

	return 0;
}

