/*
 * Copyright (C) 2003-2005 Atmark Techno, Inc.  All Rights Reserved.
 */

#ifndef _HERMIT_SUZAKU_MEMREGIONS_4MiB_H
#define _HERMIT_SUZAKU_MEMREGIONS_4MiB_H

#define FLASH_4MiB_ALL_START           (FLASH_START)
#define FLASH_4MiB_ALL_SIZE            (63*64*KiB + 8*8*KiB)
#define FLASH_4MiB_ALL_END             (FLASH_4MiB_ALL_START + FLASH_4MiB_ALL_SIZE - 1)

#define FLASH_4MiB_FPGA_START          (FLASH_START)
#define FLASH_4MiB_FPGA_SIZE           (8*64*KiB)
#define FLASH_4MiB_FPGA_END            (FLASH_4MiB_FPGA_START + FLASH_4MiB_FPGA_SIZE - 1)

#define FLASH_4MiB_BOOTLOADER_START    (FLASH_4MiB_FPGA_START + FLASH_4MiB_FPGA_SIZE)
#define FLASH_4MiB_BOOTLOADER_SIZE     (2*64*KiB)
#define FLASH_4MiB_BOOTLOADER_END      (FLASH_4MiB_BOOTLOADER_START + FLASH_4MiB_BOOTLOADER_SIZE - 1)

#define FLASH_4MiB_IMAGE_START         (FLASH_4MiB_BOOTLOADER_START + FLASH_4MiB_BOOTLOADER_SIZE)
#define FLASH_4MiB_IMAGE_SIZE          (53*64*KiB)
#define FLASH_4MiB_IMAGE_END           (FLASH_4MiB_IMAGE_START + FLASH_4MiB_IMAGE_SIZE - 1)

#define FLASH_4MiB_KERNEL_START        (FLASH_4MiB_BOOTLOADER_START + FLASH_4MiB_BOOTLOADER_SIZE)
#define FLASH_4MiB_KERNEL_SIZE         (23*64*KiB)
#define FLASH_4MiB_KERNEL_END          (FLASH_4MiB_KERNEL_START + FLASH_4MiB_KERNEL_SIZE - 1)

#define FLASH_4MiB_USER_START          (FLASH_4MiB_KERNEL_START + FLASH_4MiB_KERNEL_SIZE)
#define FLASH_4MiB_USER_SIZE           (30*64*KiB)
#define FLASH_4MiB_USER_END            (FLASH_4MiB_USER_START + FLASH_4MiB_USER_SIZE - 1)

#define FLASH_4MiB_CONFIG_START        (FLASH_4MiB_IMAGE_START + FLASH_4MiB_IMAGE_SIZE)
#define FLASH_4MiB_CONFIG_SIZE         (8*8*KiB)
#define FLASH_4MiB_CONFIG_END          (FLASH_4MiB_CONFIG_START + FLASH_4MiB_CONFIG_SIZE - 1)

#endif /* _HERMIT_SUZAKU_MEMREGIONS_4MiB_H */
